/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;

public record DebugBrainDump(String name, String profession, int xp, float health, float maxHealth, String inventory, boolean wantsGolem, int angerLevel, List<String> activities, List<String> behaviors, List<String> memories, List<String> gossips, Set<BlockPos> pois, Set<BlockPos> potentialPois) {
    public static final StreamCodec<FriendlyByteBuf, DebugBrainDump> STREAM_CODEC = StreamCodec.of((buffer, value) -> value.write((FriendlyByteBuf)((Object)buffer)), DebugBrainDump::new);

    public DebugBrainDump(FriendlyByteBuf buffer) {
        this(buffer.readUtf(), buffer.readUtf(), buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readUtf(), buffer.readBoolean(), buffer.readInt(), buffer.readList(FriendlyByteBuf::readUtf), buffer.readList(FriendlyByteBuf::readUtf), buffer.readList(FriendlyByteBuf::readUtf), buffer.readList(FriendlyByteBuf::readUtf), buffer.readCollection(HashSet::new, BlockPos.STREAM_CODEC), buffer.readCollection(HashSet::new, BlockPos.STREAM_CODEC));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.name);
        buffer.writeUtf(this.profession);
        buffer.writeInt(this.xp);
        buffer.writeFloat(this.health);
        buffer.writeFloat(this.maxHealth);
        buffer.writeUtf(this.inventory);
        buffer.writeBoolean(this.wantsGolem);
        buffer.writeInt(this.angerLevel);
        buffer.writeCollection(this.activities, FriendlyByteBuf::writeUtf);
        buffer.writeCollection(this.behaviors, FriendlyByteBuf::writeUtf);
        buffer.writeCollection(this.memories, FriendlyByteBuf::writeUtf);
        buffer.writeCollection(this.gossips, FriendlyByteBuf::writeUtf);
        buffer.writeCollection(this.pois, BlockPos.STREAM_CODEC);
        buffer.writeCollection(this.potentialPois, BlockPos.STREAM_CODEC);
    }

    public static DebugBrainDump takeBrainDump(ServerLevel level, LivingEntity entity) {
        List<String> list;
        int n;
        Villager villager1;
        boolean flag;
        InventoryCarrier inventoryCarrier;
        SimpleContainer inventory;
        int villagerXp;
        String registeredName;
        String entityName = DebugEntityNameGenerator.getEntityName(entity);
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            registeredName = villager.getVillagerData().profession().getRegisteredName();
            villagerXp = villager.getVillagerXp();
        } else {
            registeredName = "";
            villagerXp = 0;
        }
        float health = entity.getHealth();
        float maxHealth = entity.getMaxHealth();
        Brain<?> brain = entity.getBrain();
        long gameTime = entity.level().getGameTime();
        String string = entity instanceof InventoryCarrier ? ((inventory = (inventoryCarrier = (InventoryCarrier)((Object)entity)).getInventory()).isEmpty() ? "" : ((Object)inventory).toString()) : "";
        boolean bl = flag = entity instanceof Villager && (villager1 = (Villager)entity).wantsToSpawnGolem(gameTime);
        if (entity instanceof Warden) {
            Warden warden = (Warden)entity;
            n = warden.getClientAngerLevel();
        } else {
            n = -1;
        }
        int i = n;
        List<String> list2 = brain.getActiveActivities().stream().map(Activity::getName).toList();
        List<String> list1 = brain.getRunningBehaviors().stream().map(BehaviorControl::debugString).toList();
        List<String> list22 = DebugBrainDump.getMemoryDescriptions(level, entity, gameTime).map(string1 -> StringUtil.truncateStringIfNecessary(string1, 255, true)).toList();
        Set<BlockPos> knownBlockPositions = DebugBrainDump.getKnownBlockPositions(brain, MemoryModuleType.JOB_SITE, MemoryModuleType.HOME, MemoryModuleType.MEETING_POINT);
        Set<BlockPos> knownBlockPositions1 = DebugBrainDump.getKnownBlockPositions(brain, MemoryModuleType.POTENTIAL_JOB_SITE);
        if (entity instanceof Villager) {
            Villager villager2 = (Villager)entity;
            list = DebugBrainDump.getVillagerGossips(villager2);
        } else {
            list = List.of();
        }
        List<String> list3 = list;
        return new DebugBrainDump(entityName, registeredName, villagerXp, health, maxHealth, string, flag, i, list2, list1, list22, list3, knownBlockPositions, knownBlockPositions1);
    }

    @SafeVarargs
    private static Set<BlockPos> getKnownBlockPositions(Brain<?> brain, MemoryModuleType<GlobalPos> ... memoryTypes) {
        return Stream.of(memoryTypes).filter(brain::hasMemoryValue).map(brain::getMemory).flatMap(Optional::stream).map(GlobalPos::pos).collect(Collectors.toSet());
    }

    private static List<String> getVillagerGossips(Villager villager) {
        ArrayList<String> list = new ArrayList<String>();
        villager.getGossips().getGossipEntries().forEach((uuid, map) -> {
            String entityName = DebugEntityNameGenerator.getEntityName(uuid);
            map.forEach((gossipType, integer) -> list.add(entityName + ": " + String.valueOf(gossipType) + ": " + integer));
        });
        return list;
    }

    private static Stream<String> getMemoryDescriptions(ServerLevel level, LivingEntity entity, long gameTime) {
        return entity.getBrain().getMemories().entrySet().stream().map(entry -> {
            MemoryModuleType memoryModuleType = (MemoryModuleType)entry.getKey();
            Optional optional = (Optional)entry.getValue();
            return DebugBrainDump.getMemoryDescription(level, gameTime, memoryModuleType, optional);
        }).sorted();
    }

    private static String getMemoryDescription(ServerLevel level, long gameTime, MemoryModuleType<?> memoryType, Optional<? extends ExpirableValue<?>> value) {
        Object string;
        if (value.isPresent()) {
            ExpirableValue<?> expirableValue = value.get();
            Object value1 = expirableValue.getValue();
            if (memoryType == MemoryModuleType.HEARD_BELL_TIME) {
                long l = gameTime - (Long)value1;
                string = l + " ticks ago";
            } else {
                string = expirableValue.canExpire() ? DebugBrainDump.getShortDescription(level, value1) + " (ttl: " + expirableValue.getTimeToLive() + ")" : DebugBrainDump.getShortDescription(level, value1);
            }
        } else {
            string = "-";
        }
        return BuiltInRegistries.MEMORY_MODULE_TYPE.getKey(memoryType).getPath() + ": " + (String)string;
    }

    private static String getShortDescription(ServerLevel level, @Nullable Object object) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UUID.class, Entity.class, WalkTarget.class, EntityTracker.class, GlobalPos.class, BlockPosTracker.class, DamageSource.class, Collection.class}, (Object)object2, n)) {
            case -1 -> "-";
            case 0 -> {
                UUID uuid = (UUID)object2;
                yield DebugBrainDump.getShortDescription(level, level.getEntity(uuid));
            }
            case 1 -> {
                Entity entity = (Entity)object2;
                yield DebugEntityNameGenerator.getEntityName(entity);
            }
            case 2 -> {
                WalkTarget walkTarget = (WalkTarget)object2;
                yield DebugBrainDump.getShortDescription(level, walkTarget.getTarget());
            }
            case 3 -> {
                EntityTracker entityTracker = (EntityTracker)object2;
                yield DebugBrainDump.getShortDescription(level, entityTracker.getEntity());
            }
            case 4 -> {
                GlobalPos globalPos = (GlobalPos)object2;
                yield DebugBrainDump.getShortDescription(level, globalPos.pos());
            }
            case 5 -> {
                BlockPosTracker blockPosTracker = (BlockPosTracker)object2;
                yield DebugBrainDump.getShortDescription(level, blockPosTracker.currentBlockPosition());
            }
            case 6 -> {
                DamageSource damageSource = (DamageSource)object2;
                Entity entity1 = damageSource.getEntity();
                if (entity1 == null) {
                    yield object.toString();
                }
                yield DebugBrainDump.getShortDescription(level, entity1);
            }
            case 7 -> {
                Collection collection = (Collection)object2;
                yield "[" + collection.stream().map(object1 -> DebugBrainDump.getShortDescription(level, object1)).collect(Collectors.joining(", ")) + "]";
            }
            default -> object.toString();
        };
    }

    public boolean hasPoi(BlockPos pos) {
        return this.pois.contains(pos);
    }

    public boolean hasPotentialPoi(BlockPos pos) {
        return this.potentialPois.contains(pos);
    }
}

