/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.mojang.jtracy.TracyClient;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.TracyZoneFiller;

public final class Profiler {
    private static final ThreadLocal<TracyZoneFiller> TRACY_FILLER = ThreadLocal.withInitial(TracyZoneFiller::new);
    private static final ThreadLocal<ProfilerFiller> ACTIVE = new ThreadLocal();
    private static final AtomicInteger ACTIVE_COUNT = new AtomicInteger();

    private Profiler() {
    }

    public static Scope use(ProfilerFiller profiler) {
        Profiler.startUsing(profiler);
        return Profiler::stopUsing;
    }

    private static void startUsing(ProfilerFiller profiler) {
        if (ACTIVE.get() != null) {
            throw new IllegalStateException("Profiler is already active");
        }
        ProfilerFiller profilerFiller = Profiler.decorateFiller(profiler);
        ACTIVE.set(profilerFiller);
        ACTIVE_COUNT.incrementAndGet();
        profilerFiller.startTick();
    }

    private static void stopUsing() {
        ProfilerFiller profilerFiller = ACTIVE.get();
        if (profilerFiller == null) {
            throw new IllegalStateException("Profiler was not active");
        }
        ACTIVE.remove();
        ACTIVE_COUNT.decrementAndGet();
        profilerFiller.endTick();
    }

    private static ProfilerFiller decorateFiller(ProfilerFiller filler) {
        return ProfilerFiller.combine(Profiler.getDefaultFiller(), filler);
    }

    public static ProfilerFiller get() {
        return ACTIVE_COUNT.get() == 0 ? Profiler.getDefaultFiller() : Objects.requireNonNullElseGet(ACTIVE.get(), Profiler::getDefaultFiller);
    }

    private static ProfilerFiller getDefaultFiller() {
        return TracyClient.isAvailable() ? (ProfilerFiller)TRACY_FILLER.get() : InactiveProfiler.INSTANCE;
    }

    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

