/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.Queues;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public interface StrictQueue<T extends Runnable> {
    @Nullable
    public Runnable pop();

    public boolean push(T var1);

    public boolean isEmpty();

    public int size();

    public record RunnableWithPriority(int priority, Runnable task) implements Runnable
    {
        @Override
        public void run() {
            this.task.run();
        }
    }

    public static final class QueueStrictQueue
    implements StrictQueue<Runnable> {
        private final Queue<Runnable> queue;

        public QueueStrictQueue(Queue<Runnable> queue) {
            this.queue = queue;
        }

        @Override
        @Nullable
        public Runnable pop() {
            return this.queue.poll();
        }

        @Override
        public boolean push(Runnable task) {
            return this.queue.add(task);
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }

    public static final class FixedPriorityQueue
    implements StrictQueue<RunnableWithPriority> {
        private final Queue<Runnable>[] queues;
        private final AtomicInteger size = new AtomicInteger();

        public FixedPriorityQueue(int size) {
            this.queues = new Queue[size];
            for (int i = 0; i < size; ++i) {
                this.queues[i] = Queues.newConcurrentLinkedQueue();
            }
        }

        @Override
        @Nullable
        public Runnable pop() {
            for (Queue<Runnable> queue : this.queues) {
                Runnable runnable = queue.poll();
                if (runnable == null) continue;
                this.size.decrementAndGet();
                return runnable;
            }
            return null;
        }

        @Override
        public boolean push(RunnableWithPriority task) {
            int i = task.priority;
            if (i < this.queues.length && i >= 0) {
                this.queues[i].add(task);
                this.size.incrementAndGet();
                return true;
            }
            throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Priority %d not supported. Expected range [0-%d]", i, this.queues.length - 1));
        }

        @Override
        public boolean isEmpty() {
            return this.size.get() == 0;
        }

        @Override
        public int size() {
            return this.size.get();
        }
    }
}

