/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.concurrent.Immutable;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;

@Immutable
public class DifficultyInstance {
    private static final float DIFFICULTY_TIME_GLOBAL_OFFSET = -72000.0f;
    private static final float MAX_DIFFICULTY_TIME_GLOBAL = 1440000.0f;
    private static final float MAX_DIFFICULTY_TIME_LOCAL = 3600000.0f;
    private final Difficulty base;
    private final float effectiveDifficulty;

    public DifficultyInstance(Difficulty base, long levelTime, long chunkInhabitedTime, float moonPhaseFactor) {
        this.base = base;
        this.effectiveDifficulty = this.calculateDifficulty(base, levelTime, chunkInhabitedTime, moonPhaseFactor);
    }

    public Difficulty getDifficulty() {
        return this.base;
    }

    public float getEffectiveDifficulty() {
        return this.effectiveDifficulty;
    }

    public boolean isHard() {
        return this.effectiveDifficulty >= (float)Difficulty.HARD.ordinal();
    }

    public boolean isHarderThan(float difficulty) {
        return this.effectiveDifficulty > difficulty;
    }

    public float getSpecialMultiplier() {
        if (this.effectiveDifficulty < 2.0f) {
            return 0.0f;
        }
        return this.effectiveDifficulty > 4.0f ? 1.0f : (this.effectiveDifficulty - 2.0f) / 2.0f;
    }

    private float calculateDifficulty(Difficulty difficulty, long levelTime, long chunkInhabitedTime, float moonPhaseFactor) {
        if (difficulty == Difficulty.PEACEFUL) {
            return 0.0f;
        }
        boolean flag = difficulty == Difficulty.HARD;
        float f = 0.75f;
        float f1 = Mth.clamp(((float)levelTime + -72000.0f) / 1440000.0f, 0.0f, 1.0f) * 0.25f;
        f += f1;
        float f2 = 0.0f;
        f2 += Mth.clamp((float)chunkInhabitedTime / 3600000.0f, 0.0f, 1.0f) * (flag ? 1.0f : 0.75f);
        f2 += Mth.clamp(moonPhaseFactor * 0.25f, 0.0f, f1);
        if (difficulty == Difficulty.EASY) {
            f2 *= 0.5f;
        }
        return (float)difficulty.getId() * (f += f2);
    }
}

