/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.joml.Vector3f;

class InfestedMobEffect
extends MobEffect {
    private final float chanceToSpawn;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected InfestedMobEffect(MobEffectCategory category, int color, float chanceToSpawn, ToIntFunction<RandomSource> spawnedCount) {
        super(category, color, ParticleTypes.INFESTED);
        this.chanceToSpawn = chanceToSpawn;
        this.spawnedCount = spawnedCount;
    }

    @Override
    public void onMobHurt(ServerLevel level, LivingEntity entity, int amplifier, DamageSource damageSource, float amount) {
        if (entity.getRandom().nextFloat() <= this.chanceToSpawn) {
            int i = this.spawnedCount.applyAsInt(entity.getRandom());
            for (int i1 = 0; i1 < i; ++i1) {
                this.spawnSilverfish(level, entity, entity.getX(), entity.getY() + (double)entity.getBbHeight() / 2.0, entity.getZ());
            }
        }
    }

    private void spawnSilverfish(ServerLevel level, LivingEntity entity, double x, double y, double z) {
        Silverfish silverfish = EntityType.SILVERFISH.create(level, EntitySpawnReason.TRIGGERED);
        if (silverfish != null) {
            RandomSource random = entity.getRandom();
            float f = 1.5707964f;
            float f1 = Mth.randomBetween(random, -1.5707964f, 1.5707964f);
            Vector3f vector3f = entity.getLookAngle().toVector3f().mul(0.3f).mul(1.0f, 1.5f, 1.0f).rotateY(f1);
            silverfish.snapTo(x, y, z, level.getRandom().nextFloat() * 360.0f, 0.0f);
            silverfish.setDeltaMovement(new Vec3(vector3f));
            if (!level.addFreshEntity(silverfish, CreatureSpawnEvent.SpawnReason.POTION_EFFECT)) {
                return;
            }
            silverfish.playSound(SoundEvents.SILVERFISH_HURT);
        }
    }
}

