/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Set;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.event.entity.EntityRemoveEvent;

public enum ConversionType {
    SINGLE(true){

        @Override
        void convert(Mob oldMob, Mob newMob, ConversionParams conversionParams) {
            Entity vehicle;
            Entity firstPassenger = oldMob.getFirstPassenger();
            newMob.copyPosition(oldMob);
            newMob.setDeltaMovement(oldMob.getDeltaMovement());
            if (firstPassenger != null) {
                firstPassenger.stopRiding();
                firstPassenger.boardingCooldown = 0;
                for (Entity entity : newMob.getPassengers()) {
                    entity.stopRiding();
                    entity.remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.TRANSFORMATION);
                }
                firstPassenger.startRiding(newMob);
            }
            if ((vehicle = oldMob.getVehicle()) != null) {
                oldMob.stopRiding();
                newMob.startRiding(vehicle, false, false);
            }
            if (conversionParams.keepEquipment()) {
                for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
                    ItemStack itemBySlot = oldMob.getItemBySlot(equipmentSlot);
                    if (itemBySlot.isEmpty()) continue;
                    newMob.setItemSlot(equipmentSlot, itemBySlot.copyAndClear());
                    newMob.setDropChance(equipmentSlot, oldMob.getDropChances().byEquipment(equipmentSlot));
                }
            }
            newMob.fallDistance = oldMob.fallDistance;
            newMob.setSharedFlag(7, oldMob.isFallFlying());
            newMob.lastHurtByPlayerMemoryTime = oldMob.lastHurtByPlayerMemoryTime;
            newMob.hurtTime = oldMob.hurtTime;
            newMob.yBodyRot = oldMob.yBodyRot;
            newMob.setOnGround(oldMob.onGround());
            oldMob.getSleepingPos().ifPresent(newMob::setSleepingPos);
            Entity entity = oldMob.getLeashHolder();
            if (entity != null) {
                newMob.setLeashedTo(entity, true);
            }
            this.convertCommon(oldMob, newMob, conversionParams);
        }
    }
    ,
    SPLIT_ON_DEATH(false){

        @Override
        void convert(Mob oldMob, Mob newMob, ConversionParams conversionParams) {
            Entity leashHolder;
            Entity firstPassenger = oldMob.getFirstPassenger();
            if (firstPassenger != null) {
                firstPassenger.stopRiding();
            }
            if ((leashHolder = oldMob.getLeashHolder()) != null) {
                oldMob.dropLeash();
            }
            newMob.aware = oldMob.aware;
            this.convertCommon(oldMob, newMob, conversionParams);
        }
    };

    private static final Set<DataComponentType<?>> COMPONENTS_TO_COPY;
    private final boolean discardAfterConversion;

    private ConversionType(boolean discardAfterConversion) {
        this.discardAfterConversion = discardAfterConversion;
    }

    public boolean shouldDiscardAfterConversion() {
        return this.discardAfterConversion;
    }

    abstract void convert(Mob var1, Mob var2, ConversionParams var3);

    void convertCommon(Mob oldMob, Mob newMob, ConversionParams conversionParams) {
        Zombie zombie;
        newMob.setAbsorptionAmount(oldMob.getAbsorptionAmount());
        for (MobEffectInstance mobEffectInstance : oldMob.getActiveEffects()) {
            newMob.addEffect(new MobEffectInstance(mobEffectInstance));
        }
        if (oldMob.isBaby()) {
            newMob.setBaby(true);
        }
        if (oldMob instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)oldMob;
            if (newMob instanceof AgeableMob) {
                AgeableMob ageableMob1 = (AgeableMob)newMob;
                ageableMob1.setAge(ageableMob.getAge());
                ageableMob1.forcedAge = ageableMob.forcedAge;
                ageableMob1.forcedAgeTimer = ageableMob.forcedAgeTimer;
            }
        }
        Brain<UUID> brain = oldMob.getBrain();
        Brain<?> brain1 = newMob.getBrain();
        if (brain.checkMemory(MemoryModuleType.ANGRY_AT, MemoryStatus.REGISTERED) && brain.hasMemoryValue(MemoryModuleType.ANGRY_AT)) {
            brain1.setMemory(MemoryModuleType.ANGRY_AT, brain.getMemory(MemoryModuleType.ANGRY_AT));
        }
        if (conversionParams.preserveCanPickUpLoot()) {
            newMob.setCanPickUpLoot(oldMob.canPickUpLoot());
        }
        newMob.setLeftHanded(oldMob.isLeftHanded());
        newMob.setNoAi(oldMob.isNoAi());
        if (oldMob.isPersistenceRequired()) {
            newMob.setPersistenceRequired();
        }
        newMob.setCustomNameVisible(oldMob.isCustomNameVisible());
        newMob.setSharedFlagOnFire(oldMob.isOnFire());
        newMob.setInvulnerable(oldMob.isInvulnerable());
        newMob.setNoGravity(oldMob.isNoGravity());
        newMob.setPortalCooldown(oldMob.getPortalCooldown());
        newMob.setSilent(oldMob.isSilent());
        oldMob.getTags().forEach(newMob::addTag);
        for (DataComponentType<?> dataComponentType : COMPONENTS_TO_COPY) {
            ConversionType.copyComponent(oldMob, newMob, dataComponentType);
        }
        if (conversionParams.team() != null) {
            Scoreboard scoreboard = newMob.level().getScoreboard();
            scoreboard.addPlayerToTeam(newMob.getStringUUID(), conversionParams.team());
            if (oldMob.getTeam() != null && oldMob.getTeam() == conversionParams.team()) {
                scoreboard.removePlayerFromTeam(oldMob.getStringUUID(), oldMob.getTeam());
            }
        }
        if (oldMob instanceof Zombie && (zombie = (Zombie)oldMob).canBreakDoors() && newMob instanceof Zombie) {
            Zombie zombie1 = (Zombie)newMob;
            zombie1.setCanBreakDoors(true);
        }
    }

    private static <T> void copyComponent(Mob oldMob, Mob newMob, DataComponentType<T> component) {
        T object = oldMob.get(component);
        if (object != null) {
            newMob.setComponent(component, object);
        }
    }

    static {
        COMPONENTS_TO_COPY = Set.of(DataComponents.CUSTOM_NAME, DataComponents.CUSTOM_DATA);
    }
}

