/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Predicates;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public final class EntitySelector {
    public static final Predicate<Entity> ENTITY_STILL_ALIVE = Entity::isAlive;
    public static final Predicate<Entity> LIVING_ENTITY_STILL_ALIVE = entity -> entity.isAlive() && entity instanceof LivingEntity;
    public static final Predicate<Entity> ENTITY_NOT_BEING_RIDDEN = entity -> entity.isAlive() && !entity.isVehicle() && !entity.isPassenger();
    public static final Predicate<Entity> CONTAINER_ENTITY_SELECTOR = entity -> entity instanceof Container && entity.isAlive();
    public static final Predicate<Entity> NO_CREATIVE_OR_SPECTATOR = entity -> {
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (entity.isSpectator()) return false;
        if (!player.isCreative()) return true;
        return false;
    };
    public static final Predicate<Entity> NO_SPECTATORS = entity -> !entity.isSpectator();
    public static final Predicate<Entity> CAN_BE_COLLIDED_WITH = NO_SPECTATORS.and(entity -> entity.canBeCollidedWith(null));
    public static final Predicate<Entity> CAN_BE_PICKED = NO_SPECTATORS.and(Entity::isPickable);
    public static Predicate<Player> IS_INSOMNIAC = player -> {
        int playerInsomniaTicks = player.level().paperConfig().entities.behavior.playerInsomniaStartTicks;
        if (playerInsomniaTicks <= 0) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        return Mth.clamp(serverPlayer.getStats().getValue(Stats.CUSTOM.get(Stats.TIME_SINCE_REST)), 1, Integer.MAX_VALUE) >= playerInsomniaTicks;
    };
    public static final Predicate<Entity> PLAYER_AFFECTS_SPAWNING = entity -> {
        if (entity.isSpectator()) return false;
        if (!entity.isAlive()) return false;
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.affectsSpawning) return false;
        return true;
    };

    private EntitySelector() {
    }

    public static Predicate<Entity> withinDistance(double x, double y, double z, double range) {
        double d = range * range;
        return entity -> entity != null && entity.distanceToSqr(x, y, z) <= d;
    }

    public static Predicate<Entity> pushableBy(Entity entity) {
        return EntitySelector.pushable(entity, false);
    }

    public static Predicate<Entity> pushable(Entity entity, boolean ignoreClimbing) {
        PlayerTeam team = entity.getTeam();
        Team.CollisionRule collisionRule = team == null ? Team.CollisionRule.ALWAYS : ((Team)team).getCollisionRule();
        return collisionRule == Team.CollisionRule.NEVER ? Predicates.alwaysFalse() : NO_SPECTATORS.and(entity1 -> {
            Player player;
            Entity pushedEntity = entity1;
            if (!(pushedEntity.isCollidable(ignoreClimbing) && pushedEntity.canCollideWithBukkit(entity) && entity.canCollideWithBukkit(pushedEntity))) {
                return false;
            }
            if (!entity.level().isClientSide() || entity1 instanceof Player && (player = (Player)entity1).isLocalPlayer()) {
                Team.CollisionRule collisionRule1;
                PlayerTeam team1 = entity1.getTeam();
                Team.CollisionRule collisionRule2 = collisionRule1 = team1 == null ? Team.CollisionRule.ALWAYS : ((Team)team1).getCollisionRule();
                if (collisionRule1 == Team.CollisionRule.NEVER || pushedEntity instanceof Player && !GlobalConfiguration.get().collisions.enablePlayerCollisions) {
                    return false;
                }
                boolean flag = team != null && team.isAlliedTo(team1);
                return (collisionRule != Team.CollisionRule.PUSH_OWN_TEAM && collisionRule1 != Team.CollisionRule.PUSH_OWN_TEAM || !flag) && (collisionRule != Team.CollisionRule.PUSH_OTHER_TEAMS && collisionRule1 != Team.CollisionRule.PUSH_OTHER_TEAMS || flag);
            }
            return false;
        });
    }

    public static Predicate<Entity> notRiding(Entity entity) {
        return vehicle -> {
            while (vehicle.isPassenger()) {
                if ((vehicle = vehicle.getVehicle()) != entity) continue;
                return false;
            }
            return true;
        };
    }
}

