/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface SlotAccess {
    public static final SlotAccess NULL = new SlotAccess(){

        @Override
        public ItemStack get() {
            return ItemStack.EMPTY;
        }

        @Override
        public boolean set(ItemStack carried) {
            return false;
        }
    };

    public static SlotAccess of(final Supplier<ItemStack> getter, final Consumer<ItemStack> setter) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return (ItemStack)getter.get();
            }

            @Override
            public boolean set(ItemStack carried) {
                setter.accept(carried);
                return true;
            }
        };
    }

    public static SlotAccess forContainer(final Container inventory, final int slot, final Predicate<ItemStack> stackFilter) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return inventory.getItem(slot);
            }

            @Override
            public boolean set(ItemStack carried) {
                if (!stackFilter.test(carried)) {
                    return false;
                }
                inventory.setItem(slot, carried);
                return true;
            }
        };
    }

    public static SlotAccess forContainer(Container inventory, int slot) {
        return SlotAccess.forContainer(inventory, slot, stack -> true);
    }

    public static SlotAccess forEquipmentSlot(final LivingEntity entity, final EquipmentSlot slot, final Predicate<ItemStack> stackFilter) {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return entity.getItemBySlot(slot);
            }

            @Override
            public boolean set(ItemStack carried) {
                if (!stackFilter.test(carried)) {
                    return false;
                }
                entity.setItemSlot(slot, carried);
                return true;
            }
        };
    }

    public static SlotAccess forEquipmentSlot(LivingEntity entity, EquipmentSlot slot) {
        return SlotAccess.forEquipmentSlot(entity, slot, stack -> true);
    }

    public ItemStack get();

    public boolean set(ItemStack var1);
}

