/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.PoiAccess;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableLong;

public class AcquirePoi {
    public static final int SCAN_RANGE = 48;

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> acquirablePois, MemoryModuleType<GlobalPos> acquiringMemory, boolean onlyIfAdult, Optional<Byte> entityEventId, BiPredicate<ServerLevel, BlockPos> predicate) {
        return AcquirePoi.create(acquirablePois, acquiringMemory, acquiringMemory, onlyIfAdult, entityEventId, predicate);
    }

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> acquirablePois, MemoryModuleType<GlobalPos> acquiringMemory, boolean onlyIfAdult, Optional<Byte> entityEventId) {
        return AcquirePoi.create(acquirablePois, acquiringMemory, acquiringMemory, onlyIfAdult, entityEventId, (serverLevel, blockPos) -> true);
    }

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> acquirablePois, MemoryModuleType<GlobalPos> existingAbsentMemory, MemoryModuleType<GlobalPos> acquiringMemory, boolean onlyIfAdult, Optional<Byte> entityEventId, BiPredicate<ServerLevel, BlockPos> predicate) {
        int i = 5;
        int i1 = 20;
        MutableLong mutableLong = new MutableLong(0L);
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        OneShot<PathfinderMob> oneShot = BehaviorBuilder.create(arg_0 -> AcquirePoi.lambda$create$9(acquiringMemory, onlyIfAdult, mutableLong, (Long2ObjectMap)map, acquirablePois, predicate, entityEventId, arg_0));
        return acquiringMemory == existingAbsentMemory ? oneShot : BehaviorBuilder.create(instance -> instance.group(instance.absent(existingAbsentMemory)).apply((Applicative)instance, memoryAccessor -> oneShot));
    }

    @Nullable
    public static Path findPathToPois(Mob mob, Set<Pair<Holder<PoiType>, BlockPos>> poiPositions) {
        if (poiPositions.isEmpty()) {
            return null;
        }
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int i = 1;
        for (Pair<Holder<PoiType>, BlockPos> pair : poiPositions) {
            i = Math.max(i, ((PoiType)((Holder)pair.getFirst()).value()).validRange());
            set.add((BlockPos)pair.getSecond());
        }
        return mob.getNavigation().createPath(set, i);
    }

    private static /* synthetic */ App lambda$create$9(MemoryModuleType acquiringMemory, boolean onlyIfAdult, MutableLong mutableLong, Long2ObjectMap map, Predicate acquirablePois, BiPredicate predicate, Optional entityEventId, BehaviorBuilder.Instance instance) {
        return instance.group(instance.absent(acquiringMemory)).apply((Applicative)instance, memoryAccessor -> (level, mob, time) -> {
            if (onlyIfAdult && mob.isBaby()) {
                return false;
            }
            if (mutableLong.getValue() == 0L) {
                mutableLong.setValue(level.getGameTime() + (long)level.random.nextInt(20));
                return false;
            }
            if (level.getGameTime() < mutableLong.getValue()) {
                return false;
            }
            mutableLong.setValue(time + 20L + (long)level.getRandom().nextInt(20));
            if (level.paperConfig().entities.behavior.stuckEntityPoiRetryDelay.enabled() && mob.getNavigation().isStuck()) {
                mutableLong.add((long)level.paperConfig().entities.behavior.stuckEntityPoiRetryDelay.intValue());
            }
            PoiManager poiManager = level.getPoiManager();
            map.long2ObjectEntrySet().removeIf(entry -> !((JitteredLinearRetry)entry.getValue()).isStillValid(time));
            Predicate<BlockPos> predicate1 = pos -> {
                JitteredLinearRetry jitteredLinearRetry = (JitteredLinearRetry)map.get(pos.asLong());
                if (jitteredLinearRetry == null) {
                    return true;
                }
                if (!jitteredLinearRetry.shouldRetry(time)) {
                    return false;
                }
                jitteredLinearRetry.markAttempt(time);
                return true;
            };
            ArrayList<Pair<Holder<PoiType>, BlockPos>> poiposes = new ArrayList<Pair<Holder<PoiType>, BlockPos>>();
            PoiAccess.findNearestPoiPositions(poiManager, acquirablePois, predicate1, mob.blockPosition(), 48, 2304.0, PoiManager.Occupancy.HAS_SPACE, false, 5, poiposes);
            HashSet<Pair<Holder<PoiType>, BlockPos>> set = new HashSet<Pair<Holder<PoiType>, BlockPos>>(poiposes.size());
            for (Pair pair : poiposes) {
                if (!predicate.test(level, (BlockPos)pair.getSecond())) continue;
                set.add((Pair<Holder<PoiType>, BlockPos>)pair);
            }
            Path path = AcquirePoi.findPathToPois(mob, set);
            if (path != null && path.canReach()) {
                BlockPos blockPos = path.getTarget();
                poiManager.getType(blockPos).ifPresent(holder -> {
                    poiManager.take(acquirablePois, (holder1, blockPos) -> blockPos.equals(target), target, 1);
                    memoryAccessor.set(GlobalPos.of(level.dimension(), target));
                    entityEventId.ifPresent(id -> level.broadcastEntityEvent(mob, (byte)id));
                    map.clear();
                    level.debugSynchronizers().updatePoi(target);
                });
            } else {
                for (Pair pair : set) {
                    map.computeIfAbsent(((BlockPos)pair.getSecond()).asLong(), l -> new JitteredLinearRetry(level.random, time));
                }
            }
            return true;
        });
    }

    static class JitteredLinearRetry {
        private static final int MIN_INTERVAL_INCREASE = 40;
        private static final int MAX_INTERVAL_INCREASE = 80;
        private static final int MAX_RETRY_PATHFINDING_INTERVAL = 400;
        private final RandomSource random;
        private long previousAttemptTimestamp;
        private long nextScheduledAttemptTimestamp;
        private int currentDelay;

        JitteredLinearRetry(RandomSource random, long timestamp) {
            this.random = random;
            this.markAttempt(timestamp);
        }

        public void markAttempt(long timestamp) {
            this.previousAttemptTimestamp = timestamp;
            int i = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min(i, 400);
            this.nextScheduledAttemptTimestamp = timestamp + (long)this.currentDelay;
        }

        public boolean isStillValid(long timestamp) {
            return timestamp - this.previousAttemptTimestamp < 400L;
        }

        public boolean shouldRetry(long timestamp) {
            return timestamp >= this.nextScheduledAttemptTimestamp;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptTimestamp + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptTimestamp + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

