/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class VillageBoundRandomStroll {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;

    public static OneShot<PathfinderMob> create(float speedModifier) {
        return VillageBoundRandomStroll.create(speedModifier, 10, 7);
    }

    public static OneShot<PathfinderMob> create(float speedModifier, int maxHorizontalDist, int maxVerticalDist) {
        return BehaviorBuilder.create(instance -> instance.group(instance.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, walkTarget -> (level, mob, gameTime) -> {
            SectionPos sectionPos;
            SectionPos sectionPos1;
            BlockPos blockPos = mob.blockPosition();
            Vec3 pos = level.isVillage(blockPos) ? LandRandomPos.getPos(mob, maxHorizontalDist, maxVerticalDist) : ((sectionPos1 = BehaviorUtils.findSectionClosestToVillage(level, sectionPos = SectionPos.of(blockPos), 2)) != sectionPos ? DefaultRandomPos.getPosTowards(mob, maxHorizontalDist, maxVerticalDist, Vec3.atBottomCenterOf(sectionPos1.center()), 1.5707963705062866) : LandRandomPos.getPos(mob, maxHorizontalDist, maxVerticalDist));
            walkTarget.setOrErase(Optional.ofNullable(pos).map(target -> new WalkTarget((Vec3)target, speedModifier, 0)));
            return true;
        }));
    }
}

