/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;

public class WorkAtComposter
extends WorkAtPoi {
    private static final List<Item> COMPOSTABLE_ITEMS = ImmutableList.of((Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT_SEEDS);

    @Override
    protected void useWorkstation(ServerLevel level, Villager villager) {
        GlobalPos globalPos;
        BlockState blockState;
        Optional<GlobalPos> memory = villager.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        if (!memory.isEmpty() && (blockState = level.getBlockState((globalPos = memory.get()).pos())).is(Blocks.COMPOSTER)) {
            this.makeBread(level, villager);
            this.compostItems(level, villager, globalPos, blockState);
        }
    }

    private void compostItems(ServerLevel level, Villager villager, GlobalPos global, BlockState state) {
        BlockPos blockPos = global.pos();
        if (state.getValue(ComposterBlock.LEVEL) == 8) {
            state = ComposterBlock.extractProduce(villager, state, level, blockPos);
        }
        int i = 20;
        int i1 = 10;
        int[] ints = new int[COMPOSTABLE_ITEMS.size()];
        SimpleContainer inventory = villager.getInventory();
        int containerSize = inventory.getContainerSize();
        BlockState blockState = state;
        for (int i2 = containerSize - 1; i2 >= 0 && i > 0; --i2) {
            int i3;
            ItemStack item = inventory.getItem(i2);
            int index = COMPOSTABLE_ITEMS.indexOf(item.getItem());
            if (index == -1) continue;
            int count = item.getCount();
            ints[index] = i3 = ints[index] + count;
            int min = Math.min(Math.min(i3 - 10, i), count);
            if (min <= 0) continue;
            i -= min;
            for (int i4 = 0; i4 < min; ++i4) {
                if ((blockState = ComposterBlock.insertItem(villager, blockState, level, item, blockPos)).getValue(ComposterBlock.LEVEL) != 7) continue;
                this.spawnComposterFillEffects(level, state, blockPos, blockState);
                return;
            }
        }
        this.spawnComposterFillEffects(level, state, blockPos, blockState);
    }

    private void spawnComposterFillEffects(ServerLevel level, BlockState preState, BlockPos pos, BlockState postState) {
        level.levelEvent(1500, pos, postState != preState ? 1 : 0);
    }

    private void makeBread(ServerLevel level, Villager villager) {
        SimpleContainer inventory = villager.getInventory();
        if (inventory.countItem(Items.BREAD) <= 36) {
            int i = inventory.countItem(Items.WHEAT);
            int i1 = 3;
            int i2 = 3;
            int min = Math.min(3, i / 3);
            if (min != 0) {
                int i3 = min * 3;
                inventory.removeItemType(Items.WHEAT, i3);
                ItemStack itemStack = inventory.addItem(new ItemStack(Items.BREAD, min));
                if (!itemStack.isEmpty()) {
                    villager.forceDrops = true;
                    villager.spawnAtLocation(level, itemStack, 0.5f);
                    villager.forceDrops = false;
                }
            }
        }
    }
}

