/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;

public class AirAndWaterRandomPos {
    @Nullable
    public static Vec3 getPos(PathfinderMob mob, int maxDistance, int yRange, int y, double x, double z, double amplifier) {
        boolean flag = GoalUtils.mobRestricted(mob, maxDistance);
        return RandomPos.generateRandomPos(mob, () -> AirAndWaterRandomPos.generateRandomPos(mob, maxDistance, yRange, y, x, z, amplifier, flag));
    }

    @Nullable
    public static BlockPos generateRandomPos(PathfinderMob mob, int maxDistance, int yRange, int y, double x, double z, double amplifier, boolean isRestricted) {
        BlockPos blockPos = RandomPos.generateRandomDirectionWithinRadians(mob.getRandom(), maxDistance, yRange, y, x, z, amplifier);
        if (blockPos == null) {
            return null;
        }
        BlockPos blockPos1 = RandomPos.generateRandomPosTowardDirection(mob, maxDistance, mob.getRandom(), blockPos);
        if (!GoalUtils.isOutsideLimits(blockPos1, mob) && !GoalUtils.isRestricted(isRestricted, mob, blockPos1)) {
            return GoalUtils.hasMalus(mob, blockPos1 = RandomPos.moveUpOutOfSolid(blockPos1, mob.level().getMaxY(), pos -> GoalUtils.isSolid(mob, pos))) ? null : blockPos1;
        }
        return null;
    }
}

