/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class RandomPos {
    private static final int RANDOM_POS_ATTEMPTS = 10;

    public static BlockPos generateRandomDirection(RandomSource random, int horizontalDistance, int verticalDistance) {
        int i = random.nextInt(2 * horizontalDistance + 1) - horizontalDistance;
        int i1 = random.nextInt(2 * verticalDistance + 1) - verticalDistance;
        int i2 = random.nextInt(2 * horizontalDistance + 1) - horizontalDistance;
        return new BlockPos(i, i1, i2);
    }

    @Nullable
    public static BlockPos generateRandomDirectionWithinRadians(RandomSource random, int maxHorizontalDifference, int yRange, int y, double x, double z, double maxAngleDelta) {
        double d = Mth.atan2(z, x) - 1.5707963705062866;
        double d1 = d + (double)(2.0f * random.nextFloat() - 1.0f) * maxAngleDelta;
        double d2 = Math.sqrt(random.nextDouble()) * (double)Mth.SQRT_OF_TWO * (double)maxHorizontalDifference;
        double d3 = -d2 * Math.sin(d1);
        double d4 = d2 * Math.cos(d1);
        if (!(Math.abs(d3) > (double)maxHorizontalDifference) && !(Math.abs(d4) > (double)maxHorizontalDifference)) {
            int i = random.nextInt(2 * yRange + 1) - yRange + y;
            return BlockPos.containing(d3, i, d4);
        }
        return null;
    }

    @VisibleForTesting
    public static BlockPos moveUpOutOfSolid(BlockPos pos, int maxY, Predicate<BlockPos> posPredicate) {
        if (!posPredicate.test(pos)) {
            return pos;
        }
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable().move(Direction.UP);
        while (mutableBlockPos.getY() <= maxY && posPredicate.test(mutableBlockPos)) {
            mutableBlockPos.move(Direction.UP);
        }
        return mutableBlockPos.immutable();
    }

    @VisibleForTesting
    public static BlockPos moveUpToAboveSolid(BlockPos pos, int aboveSolidAmount, int maxY, Predicate<BlockPos> posPredicate) {
        if (aboveSolidAmount < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + aboveSolidAmount + ", expected >= 0");
        }
        if (!posPredicate.test(pos)) {
            return pos;
        }
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable().move(Direction.UP);
        while (mutableBlockPos.getY() <= maxY && posPredicate.test(mutableBlockPos)) {
            mutableBlockPos.move(Direction.UP);
        }
        int y = mutableBlockPos.getY();
        while (mutableBlockPos.getY() <= maxY && mutableBlockPos.getY() - y < aboveSolidAmount) {
            mutableBlockPos.move(Direction.UP);
            if (!posPredicate.test(mutableBlockPos)) continue;
            mutableBlockPos.move(Direction.DOWN);
            break;
        }
        return mutableBlockPos.immutable();
    }

    @Nullable
    public static Vec3 generateRandomPos(PathfinderMob mob, Supplier<BlockPos> posSupplier) {
        return RandomPos.generateRandomPos(posSupplier, mob::getWalkTargetValue);
    }

    @Nullable
    public static Vec3 generateRandomPos(Supplier<BlockPos> posSupplier, ToDoubleFunction<BlockPos> toDoubleFunction) {
        double d = Double.NEGATIVE_INFINITY;
        BlockPos blockPos = null;
        for (int i = 0; i < 10; ++i) {
            double d1;
            BlockPos blockPos1 = posSupplier.get();
            if (blockPos1 == null || !((d1 = toDoubleFunction.applyAsDouble(blockPos1)) > d)) continue;
            d = d1;
            blockPos = blockPos1;
        }
        return blockPos != null ? Vec3.atBottomCenterOf(blockPos) : null;
    }

    public static BlockPos generateRandomPosTowardDirection(PathfinderMob mob, int range, RandomSource random, BlockPos pos) {
        int x = pos.getX();
        int z = pos.getZ();
        if (mob.hasHome() && range > 1) {
            BlockPos homePosition = mob.getHomePosition();
            x = mob.getX() > (double)homePosition.getX() ? (x -= random.nextInt(range / 2)) : (x += random.nextInt(range / 2));
            z = mob.getZ() > (double)homePosition.getZ() ? (z -= random.nextInt(range / 2)) : (z += random.nextInt(range / 2));
        }
        return BlockPos.containing((double)x + mob.getX(), (double)pos.getY() + mob.getY(), (double)z + mob.getZ());
    }
}

