/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;

public class StartAdmiringItemIfSeen {
    public static BehaviorControl<LivingEntity> create(int admireDuration) {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), instance.absent(MemoryModuleType.ADMIRING_ITEM), instance.absent(MemoryModuleType.ADMIRING_DISABLED), instance.absent(MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM)).apply((Applicative)instance, (nearestVisibleWantedItem, admiringItem, admiringDisabled, disableWalkToAdmireItem) -> (level, entity, gameTime) -> {
            ItemEntity itemEntity = (ItemEntity)instance.get(nearestVisibleWantedItem);
            if (!PiglinAi.isLovedItem(itemEntity.getItem())) {
                return false;
            }
            admiringItem.setWithExpiry(true, admireDuration);
            return true;
        }));
    }
}

