/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.variant;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;

public interface PriorityProvider<Context, Condition extends SelectorCondition<Context>> {
    public List<Selector<Context, Condition>> selectors();

    public static <C, T> Stream<T> select(Stream<T> elements, Function<T, PriorityProvider<C, ?>> entryGetter, C context) {
        ArrayList list = new ArrayList();
        elements.forEach(object -> {
            PriorityProvider priorityProvider = (PriorityProvider)entryGetter.apply(object);
            for (Selector selector : priorityProvider.selectors()) {
                list.add(new UnpackedEntry(object, selector.priority(), (SelectorCondition)DataFixUtils.orElseGet(selector.condition(), SelectorCondition::alwaysTrue)));
            }
        });
        list.sort(UnpackedEntry.HIGHEST_PRIORITY_FIRST);
        Iterator iterator = list.iterator();
        int i = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            UnpackedEntry unpackedEntry = (UnpackedEntry)iterator.next();
            if (unpackedEntry.priority < i) {
                iterator.remove();
                continue;
            }
            if (unpackedEntry.condition.test(context)) {
                i = unpackedEntry.priority;
                continue;
            }
            iterator.remove();
        }
        return list.stream().map(UnpackedEntry::entry);
    }

    public static <C, T> Optional<T> pick(Stream<T> elements, Function<T, PriorityProvider<C, ?>> entryGetter, RandomSource random, C context) {
        List<T> list = PriorityProvider.select(elements, entryGetter, context).toList();
        return Util.getRandomSafe(list, random);
    }

    public static <Context, Condition extends SelectorCondition<Context>> List<Selector<Context, Condition>> single(Condition condition, int priority) {
        return List.of(new Selector(condition, priority));
    }

    public static <Context, Condition extends SelectorCondition<Context>> List<Selector<Context, Condition>> alwaysTrue(int priority) {
        return List.of(new Selector(Optional.empty(), priority));
    }

    public record UnpackedEntry<C, T>(T entry, int priority, SelectorCondition<C> condition) {
        public static final Comparator<UnpackedEntry<?, ?>> HIGHEST_PRIORITY_FIRST = Comparator.comparingInt(UnpackedEntry::priority).reversed();
    }

    @FunctionalInterface
    public static interface SelectorCondition<C>
    extends Predicate<C> {
        public static <C> SelectorCondition<C> alwaysTrue() {
            return object -> true;
        }
    }

    public record Selector<Context, Condition extends SelectorCondition<Context>>(Optional<Condition> condition, int priority) {
        public Selector(Condition condition, int priority) {
            this(Optional.of(condition), priority);
        }

        public Selector(int priority) {
            this(Optional.empty(), priority);
        }

        public static <Context, Condition extends SelectorCondition<Context>> Codec<Selector<Context, Condition>> codec(Codec<Condition> conditionCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)conditionCodec.optionalFieldOf("condition").forGetter(Selector::condition), (App)Codec.INT.fieldOf("priority").forGetter(Selector::priority)).apply((Applicative)instance, Selector::new));
        }
    }
}

