/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class MinecartItem
extends Item {
    private final EntityType<? extends AbstractMinecart> type;

    public MinecartItem(EntityType<? extends AbstractMinecart> type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos clickedPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(clickedPos = context.getClickedPos());
        if (!blockState.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemInHand = context.getItemInHand();
        RailShape railShape = blockState.getBlock() instanceof BaseRailBlock ? blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
        double d = 0.0;
        if (railShape.isSlope()) {
            d = 0.5;
        }
        Vec3 vec3 = new Vec3((double)clickedPos.getX() + 0.5, (double)clickedPos.getY() + 0.0625 + d, (double)clickedPos.getZ() + 0.5);
        AbstractMinecart abstractMinecart = AbstractMinecart.createMinecart(level, vec3.x, vec3.y, vec3.z, this.type, EntitySpawnReason.DISPENSER, itemInHand, context.getPlayer());
        if (abstractMinecart == null) {
            return InteractionResult.FAIL;
        }
        if (AbstractMinecart.useExperimentalMovement(level)) {
            for (Entity entity : level.getEntities(null, abstractMinecart.getBoundingBox())) {
                if (!(entity instanceof AbstractMinecart)) continue;
                return InteractionResult.FAIL;
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (CraftEventFactory.callEntityPlaceEvent(context, abstractMinecart).isCancelled()) {
                if (context.getPlayer() != null) {
                    context.getPlayer().containerMenu.forceHeldSlot(context.getHand());
                }
                return InteractionResult.FAIL;
            }
            if (!serverLevel.addFreshEntity(abstractMinecart)) {
                return InteractionResult.PASS;
            }
            serverLevel.gameEvent(GameEvent.ENTITY_PLACE, clickedPos, GameEvent.Context.of(context.getPlayer(), serverLevel.getBlockState(clickedPos.below())));
        }
        itemInHand.shrink(1);
        return InteractionResult.SUCCESS;
    }
}

