/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;

public final class ShapedRecipePattern {
    private static final int MAX_SIZE = 3;
    public static final char EMPTY_SLOT = ' ';
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = Data.MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, pattern -> pattern.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, shapedRecipePattern -> shapedRecipePattern.width, ByteBufCodecs.VAR_INT, shapedRecipePattern -> shapedRecipePattern.height, Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), shapedRecipePattern -> shapedRecipePattern.ingredients, ShapedRecipePattern::createFromNetwork);
    private final int width;
    private final int height;
    private final List<Optional<Ingredient>> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public ShapedRecipePattern(int width, int height, List<Optional<Ingredient>> ingredients, Optional<Data> data) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.data = data;
        this.ingredientCount = (int)ingredients.stream().flatMap(Optional::stream).count();
        this.symmetrical = Util.isSymmetrical(width, height, ingredients);
    }

    private static ShapedRecipePattern createFromNetwork(Integer width, Integer height, List<Optional<Ingredient>> ingredients) {
        return new ShapedRecipePattern(width, height, ingredients, Optional.empty());
    }

    public static ShapedRecipePattern of(Map<Character, Ingredient> key, String ... pattern) {
        return ShapedRecipePattern.of(key, List.of(pattern));
    }

    public static ShapedRecipePattern of(Map<Character, Ingredient> key, List<String> pattern) {
        Data data = new Data(key, pattern);
        return (ShapedRecipePattern)ShapedRecipePattern.unpack(data).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> unpack(Data data) {
        String[] strings = ShapedRecipePattern.shrink(data.pattern);
        int len = strings[0].length();
        int i = strings.length;
        ArrayList<Optional<Ingredient>> list = new ArrayList<Optional<Ingredient>>(len * i);
        CharArraySet set = new CharArraySet(data.key.keySet());
        for (String string : strings) {
            for (int i1 = 0; i1 < string.length(); ++i1) {
                Optional<Object> optional;
                char c = string.charAt(i1);
                if (c == ' ') {
                    optional = Optional.empty();
                } else {
                    Ingredient ingredient = data.key.get(Character.valueOf(c));
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                    }
                    optional = Optional.of(ingredient);
                }
                set.remove(c);
                list.add(optional);
            }
        }
        return !set.isEmpty() ? DataResult.error(() -> ShapedRecipePattern.lambda$unpack$7((CharSet)set)) : DataResult.success((Object)new ShapedRecipePattern(len, i, list, Optional.of(data)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> pattern) {
        int i = Integer.MAX_VALUE;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        for (int i4 = 0; i4 < pattern.size(); ++i4) {
            String string = pattern.get(i4);
            i = Math.min(i, ShapedRecipePattern.firstNonEmpty(string));
            int i5 = ShapedRecipePattern.lastNonEmpty(string);
            i1 = Math.max(i1, i5);
            if (i5 < 0) {
                if (i2 == i4) {
                    ++i2;
                }
                ++i3;
                continue;
            }
            i3 = 0;
        }
        if (pattern.size() == i3) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - i3 - i2];
        for (int i6 = 0; i6 < strings.length; ++i6) {
            strings[i6] = pattern.get(i6 + i2).substring(i, i1 + 1);
        }
        return strings;
    }

    private static int firstNonEmpty(String row) {
        int i;
        for (i = 0; i < row.length() && row.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonEmpty(String row) {
        int i;
        for (i = row.length() - 1; i >= 0 && row.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public boolean matches(CraftingInput input) {
        if (input.ingredientCount() != this.ingredientCount) {
            return false;
        }
        if (input.width() == this.width && input.height() == this.height) {
            if (!this.symmetrical && this.matches(input, true)) {
                return true;
            }
            if (this.matches(input, false)) {
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingInput input, boolean symmetrical) {
        for (int i = 0; i < this.height; ++i) {
            for (int i1 = 0; i1 < this.width; ++i1) {
                ItemStack item;
                Optional<Ingredient> optional = symmetrical ? this.ingredients.get(this.width - i1 - 1 + i * this.width) : this.ingredients.get(i1 + i * this.width);
                if (Ingredient.testOptionalIngredient(optional, item = input.getItem(i1, i))) continue;
                return false;
            }
        }
        return true;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public List<Optional<Ingredient>> ingredients() {
        return this.ingredients;
    }

    private static /* synthetic */ String lambda$unpack$7(CharSet set) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(set);
    }

    public record Data(Map<Character, Ingredient> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(patternEntry -> {
            if (patternEntry.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (patternEntry.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int len = ((String)patternEntry.getFirst()).length();
            for (String string : patternEntry) {
                if (string.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (len == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)patternEntry);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(symbol -> {
            if (symbol.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + symbol + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(symbol) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(symbol.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, Ingredient.CODEC).fieldOf("key").forGetter(data -> data.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)).apply((Applicative)instance, Data::new));
    }
}

