/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MossyCarpetBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<MossyCarpetBlock> CODEC = MossyCarpetBlock.simpleCodec(MossyCarpetBlock::new);
    public static final BooleanProperty BASE = BlockStateProperties.BOTTOM;
    public static final EnumProperty<WallSide> NORTH = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> EAST = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> SOUTH = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST = BlockStateProperties.WEST_WALL;
    public static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST)));
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<MossyCarpetBlock> codec() {
        return CODEC;
    }

    public MossyCarpetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(BASE, true)).setValue(NORTH, WallSide.NONE)).setValue(EAST, WallSide.NONE)).setValue(SOUTH, WallSide.NONE)).setValue(WEST, WallSide.NONE));
        this.shapes = this.makeShapes();
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState state) {
        return Shapes.empty();
    }

    public Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> map = Shapes.rotateHorizontal(Block.boxZ(16.0, 0.0, 10.0, 0.0, 1.0));
        Map<Direction, VoxelShape> map1 = Shapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(blockState -> {
            VoxelShape voxelShape = blockState.getValue(BASE) != false ? (VoxelShape)map1.get(Direction.DOWN) : Shapes.empty();
            block4: for (Map.Entry<Direction, EnumProperty<WallSide>> entry : PROPERTY_BY_DIRECTION.entrySet()) {
                switch ((WallSide)blockState.getValue(entry.getValue())) {
                    default: {
                        continue block4;
                    }
                    case LOW: {
                        voxelShape = Shapes.or(voxelShape, (VoxelShape)map.get(entry.getKey()));
                        continue block4;
                    }
                    case TALL: 
                }
                voxelShape = Shapes.or(voxelShape, (VoxelShape)map1.get(entry.getKey()));
            }
            return voxelShape.isEmpty() ? Shapes.block() : voxelShape;
        });
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.apply(state);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(BASE) != false ? this.shapes.apply(this.defaultBlockState()) : Shapes.empty();
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.below());
        return state.getValue(BASE).booleanValue() ? !blockState.isAir() : blockState.is(this) && blockState.getValue(BASE) != false;
    }

    private static boolean hasFaces(BlockState state) {
        if (state.getValue(BASE).booleanValue()) {
            return true;
        }
        for (EnumProperty<WallSide> enumProperty : PROPERTY_BY_DIRECTION.values()) {
            if (state.getValue(enumProperty) == WallSide.NONE) continue;
            return true;
        }
        return false;
    }

    private static boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        return direction != Direction.UP && MultifaceBlock.canAttachTo(level, pos, direction);
    }

    private static BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos, boolean tip) {
        BlockBehaviour.BlockStateBase blockState = null;
        BlockBehaviour.BlockStateBase blockState1 = null;
        tip |= state.getValue(BASE).booleanValue();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            WallSide wallSide;
            EnumProperty<WallSide> propertyForFace = MossyCarpetBlock.getPropertyForFace(direction);
            WallSide wallSide2 = MossyCarpetBlock.canSupportAtFace(level, pos, direction) ? (tip ? WallSide.LOW : state.getValue(propertyForFace)) : (wallSide = WallSide.NONE);
            if (wallSide == WallSide.LOW) {
                if (blockState == null) {
                    blockState = level.getBlockState(pos.above());
                }
                if (blockState.is(Blocks.PALE_MOSS_CARPET) && blockState.getValue(propertyForFace) != WallSide.NONE && !blockState.getValue(BASE).booleanValue()) {
                    wallSide = WallSide.TALL;
                }
                if (!state.getValue(BASE).booleanValue()) {
                    if (blockState1 == null) {
                        blockState1 = level.getBlockState(pos.below());
                    }
                    if (blockState1.is(Blocks.PALE_MOSS_CARPET) && blockState1.getValue(propertyForFace) == WallSide.NONE) {
                        wallSide = WallSide.NONE;
                    }
                }
            }
            state = (BlockState)state.setValue(propertyForFace, wallSide);
        }
        return state;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return MossyCarpetBlock.getUpdatedState(this.defaultBlockState(), context.getLevel(), context.getClickedPos(), true);
    }

    public static void placeAt(LevelAccessor level, BlockPos pos, RandomSource random, int flags) {
        BlockState blockState = Blocks.PALE_MOSS_CARPET.defaultBlockState();
        BlockState updatedState = MossyCarpetBlock.getUpdatedState(blockState, level, pos, true);
        level.setBlock(pos, updatedState, flags);
        BlockState blockState1 = MossyCarpetBlock.createTopperWithSideChance(level, pos, random::nextBoolean);
        if (!blockState1.isAir()) {
            level.setBlock(pos.above(), blockState1, flags);
            BlockState updatedState1 = MossyCarpetBlock.getUpdatedState(updatedState, level, pos, true);
            level.setBlock(pos, updatedState1, flags);
        }
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.isClientSide()) {
            RandomSource random = level.getRandom();
            BlockState blockState = MossyCarpetBlock.createTopperWithSideChance(level, pos, random::nextBoolean);
            if (!blockState.isAir()) {
                level.setBlock(pos.above(), blockState, 3);
            }
        }
    }

    private static BlockState createTopperWithSideChance(BlockGetter level, BlockPos pos, BooleanSupplier placeSide) {
        BlockPos blockPos = pos.above();
        BlockState blockState = level.getBlockState(blockPos);
        boolean isPaleMossCarpet = blockState.is(Blocks.PALE_MOSS_CARPET);
        if (!(isPaleMossCarpet && blockState.getValue(BASE).booleanValue() || !isPaleMossCarpet && !blockState.canBeReplaced())) {
            BlockState blockState1 = (BlockState)Blocks.PALE_MOSS_CARPET.defaultBlockState().setValue(BASE, false);
            BlockState updatedState = MossyCarpetBlock.getUpdatedState(blockState1, level, pos.above(), true);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                EnumProperty<WallSide> propertyForFace = MossyCarpetBlock.getPropertyForFace(direction);
                if (updatedState.getValue(propertyForFace) == WallSide.NONE || placeSide.getAsBoolean()) continue;
                updatedState = (BlockState)updatedState.setValue(propertyForFace, WallSide.NONE);
            }
            return MossyCarpetBlock.hasFaces(updatedState) && updatedState != blockState ? updatedState : Blocks.AIR.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (!state.canSurvive(level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState updatedState = MossyCarpetBlock.getUpdatedState(state, level, pos, false);
        return !MossyCarpetBlock.hasFaces(updatedState) ? Blocks.AIR.defaultBlockState() : updatedState;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(BASE, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(EAST, state.getValue(WEST))).setValue(SOUTH, state.getValue(NORTH))).setValue(WEST, state.getValue(EAST));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(EAST))).setValue(EAST, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(WEST))).setValue(WEST, state.getValue(NORTH));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(WEST))).setValue(EAST, state.getValue(NORTH))).setValue(SOUTH, state.getValue(EAST))).setValue(WEST, state.getValue(SOUTH));
            default -> state;
        };
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(NORTH));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(EAST, state.getValue(WEST))).setValue(WEST, state.getValue(EAST));
            default -> super.mirror(state, mirror);
        };
    }

    @Nullable
    public static EnumProperty<WallSide> getPropertyForFace(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return state.getValue(BASE) != false && !MossyCarpetBlock.createTopperWithSideChance(level, pos, () -> true).isAir();
    }

    @Override
    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState blockState = MossyCarpetBlock.createTopperWithSideChance(level, pos, () -> true);
        if (!blockState.isAir()) {
            level.setBlock(pos.above(), blockState, 3);
        }
    }
}

