/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class SculkBlock
extends DropExperienceBlock
implements SculkBehaviour {
    public static final MapCodec<SculkBlock> CODEC = SculkBlock.simpleCodec(SculkBlock::new);

    public MapCodec<SculkBlock> codec() {
        return CODEC;
    }

    public SculkBlock(BlockBehaviour.Properties properties) {
        super(ConstantInt.of(1), properties);
    }

    @Override
    public int attemptUseCharge(SculkSpreader.ChargeCursor cursor, LevelAccessor level, BlockPos pos, RandomSource random, SculkSpreader spreader, boolean shouldConvertBlocks) {
        int charge = cursor.getCharge();
        if (charge != 0 && random.nextInt(spreader.chargeDecayRate()) == 0) {
            BlockPos pos1 = cursor.getPos();
            boolean flag = pos1.closerThan(pos, spreader.noGrowthRadius());
            if (!flag && SculkBlock.canPlaceGrowth(level, pos1)) {
                BlockState randomGrowthState;
                BlockPos blockPos;
                int growthSpawnCost = spreader.growthSpawnCost();
                if (random.nextInt(growthSpawnCost) < charge && CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos = pos1.above(), randomGrowthState = this.getRandomGrowthState(level, blockPos, random, spreader.isWorldGeneration()), 3)) {
                    level.playSound(null, pos1, randomGrowthState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, charge - growthSpawnCost);
            }
            return random.nextInt(spreader.additionalDecayRate()) != 0 ? charge : charge - (flag ? 1 : SculkBlock.getDecayPenalty(spreader, pos1, pos, charge));
        }
        return charge;
    }

    private static int getDecayPenalty(SculkSpreader spreader, BlockPos cursorPos, BlockPos rootPos, int charge) {
        int noGrowthRadius = spreader.noGrowthRadius();
        float squared = Mth.square((float)Math.sqrt(cursorPos.distSqr(rootPos)) - (float)noGrowthRadius);
        int squared1 = Mth.square(24 - noGrowthRadius);
        float min = Math.min(1.0f, squared / (float)squared1);
        return Math.max(1, (int)((float)charge * min * 0.5f));
    }

    private BlockState getRandomGrowthState(LevelAccessor level, BlockPos pos, RandomSource random, boolean isWorldGeneration) {
        BlockState blockState = random.nextInt(11) == 0 ? (BlockState)Blocks.SCULK_SHRIEKER.defaultBlockState().setValue(SculkShriekerBlock.CAN_SUMMON, isWorldGeneration) : Blocks.SCULK_SENSOR.defaultBlockState();
        return blockState.hasProperty(BlockStateProperties.WATERLOGGED) && !level.getFluidState(pos).isEmpty() ? (BlockState)blockState.setValue(BlockStateProperties.WATERLOGGED, true) : blockState;
    }

    private static boolean canPlaceGrowth(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.above());
        if (blockState.isAir() || blockState.is(Blocks.WATER) && blockState.getFluidState().is(Fluids.WATER)) {
            int i = 0;
            for (BlockPos blockPos : BlockPos.betweenClosed(pos.offset(-4, 0, -4), pos.offset(4, 2, 4))) {
                BlockState blockState1 = level.getBlockState(blockPos);
                if (blockState1.is(Blocks.SCULK_SENSOR) || blockState1.is(Blocks.SCULK_SHRIEKER)) {
                    ++i;
                }
                if (i <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canChangeBlockStateOnSpread() {
        return false;
    }
}

