/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public abstract class ContainerOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount;
    private double maxInteractionRange;
    public boolean opened;

    public void onAPIOpen(Level level, BlockPos blockPos, BlockState blockState) {
        this.onOpen(level, blockPos, blockState);
    }

    public void onAPIClose(Level level, BlockPos blockPos, BlockState blockState) {
        this.onClose(level, blockPos, blockState);
    }

    public void openerAPICountChanged(Level level, BlockPos blockPos, BlockState blockState, int count, int openCount) {
        this.openerCountChanged(level, blockPos, blockState, count, openCount);
    }

    protected abstract void onOpen(Level var1, BlockPos var2, BlockState var3);

    protected abstract void onClose(Level var1, BlockPos var2, BlockState var3);

    protected abstract void openerCountChanged(Level var1, BlockPos var2, BlockState var3, int var4, int var5);

    public abstract boolean isOwnContainer(Player var1);

    public void incrementOpeners(LivingEntity entity, Level level, BlockPos pos, BlockState state, double interactionRange) {
        int newPower;
        int oldPower = Math.max(0, Math.min(15, this.openCount));
        int i = this.openCount++;
        if (level.getBlockState(pos).is(Blocks.TRAPPED_CHEST) && oldPower != (newPower = Math.max(0, Math.min(15, this.openCount)))) {
            CraftEventFactory.callRedstoneChange(level, pos, oldPower, newPower);
        }
        if (i == 0) {
            this.onOpen(level, pos, state);
            level.gameEvent((Entity)entity, GameEvent.CONTAINER_OPEN, pos);
            ContainerOpenersCounter.scheduleRecheck(level, pos, state);
        }
        this.openerCountChanged(level, pos, state, i, this.openCount);
        this.maxInteractionRange = Math.max(interactionRange, this.maxInteractionRange);
    }

    public void decrementOpeners(LivingEntity entity, Level level, BlockPos pos, BlockState state) {
        int newPower;
        int oldPower = Math.max(0, Math.min(15, this.openCount));
        if (this.openCount == 0) {
            return;
        }
        int i = this.openCount--;
        if (level.getBlockState(pos).is(Blocks.TRAPPED_CHEST) && oldPower != (newPower = Math.max(0, Math.min(15, this.openCount)))) {
            CraftEventFactory.callRedstoneChange(level, pos, oldPower, newPower);
        }
        if (this.openCount == 0) {
            this.onClose(level, pos, state);
            level.gameEvent((Entity)entity, GameEvent.CONTAINER_CLOSE, pos);
            this.maxInteractionRange = 0.0;
        }
        this.openerCountChanged(level, pos, state, i, this.openCount);
    }

    public List<ContainerUser> getEntitiesWithContainerOpen(Level level, BlockPos pos) {
        double d = this.maxInteractionRange + 4.0;
        AABB aabb = new AABB(pos).inflate(d);
        return level.getEntities((Entity)null, aabb, entity -> this.hasContainerOpen((Entity)entity, pos)).stream().map(entity -> (ContainerUser)((Object)entity)).collect(Collectors.toList());
    }

    private boolean hasContainerOpen(Entity entity, BlockPos pos) {
        ContainerUser containerUser;
        return entity instanceof ContainerUser && !(containerUser = (ContainerUser)((Object)entity)).getLivingEntity().isSpectator() && containerUser.hasContainerOpen(this, pos);
    }

    public void recheckOpeners(Level level, BlockPos pos, BlockState state) {
        int i;
        List<ContainerUser> entitiesWithContainerOpen = this.getEntitiesWithContainerOpen(level, pos);
        this.maxInteractionRange = 0.0;
        for (ContainerUser containerUser : entitiesWithContainerOpen) {
            this.maxInteractionRange = Math.max(containerUser.getContainerInteractionRange(), this.maxInteractionRange);
        }
        int size = entitiesWithContainerOpen.size();
        if (this.opened) {
            ++size;
        }
        if ((i = this.openCount) != size) {
            boolean flag1;
            boolean flag = size != 0;
            boolean bl = flag1 = i != 0;
            if (flag && !flag1) {
                this.onOpen(level, pos, state);
                level.gameEvent(null, GameEvent.CONTAINER_OPEN, pos);
            } else if (!flag) {
                this.onClose(level, pos, state);
                level.gameEvent(null, GameEvent.CONTAINER_CLOSE, pos);
            }
            this.openCount = size;
        }
        this.openerCountChanged(level, pos, state, i, size);
        if (size > 0) {
            ContainerOpenersCounter.scheduleRecheck(level, pos, state);
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }

    private static void scheduleRecheck(Level level, BlockPos pos, BlockState state) {
        level.scheduleTick(pos, state.getBlock(), 5);
    }
}

