/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class TrialSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerStateData data = new TrialSpawnerStateData();
    public FullConfig config;
    public final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    public boolean isOminous;

    public TrialSpawner(FullConfig config, StateAccessor stateAccessor, PlayerDetector playerDetector, PlayerDetector.EntitySelector entitySelector) {
        this.config = config;
        this.stateAccessor = stateAccessor;
        this.playerDetector = playerDetector;
        this.entitySelector = entitySelector;
    }

    public TrialSpawnerConfig activeConfig() {
        return this.isOminous ? this.config.ominous().value() : this.config.normal.value();
    }

    public TrialSpawnerConfig normalConfig() {
        return this.config.normal.value();
    }

    public TrialSpawnerConfig ominousConfig() {
        return this.config.ominous.value();
    }

    public void load(ValueInput input) {
        input.read(TrialSpawnerStateData.Packed.MAP_CODEC).ifPresent(this.data::apply);
        this.config = input.read(FullConfig.MAP_CODEC).orElse(FullConfig.DEFAULT);
    }

    public void store(ValueOutput output) {
        output.store(TrialSpawnerStateData.Packed.MAP_CODEC, this.data.pack());
        output.store(FullConfig.MAP_CODEC, this.config);
    }

    public void applyOminous(ServerLevel level, BlockPos pos) {
        level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        level.levelEvent(3020, pos, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, level);
    }

    public void removeOminous(ServerLevel level, BlockPos pos) {
        level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public int getTargetCooldownLength() {
        return this.config.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.config.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public TrialSpawnerStateData getStateData() {
        return this.data;
    }

    public void setState(Level level, TrialSpawnerState state) {
        this.stateAccessor.setState(level, state);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(ServerLevel level) {
        return level.getServer().getGameRules().getBoolean(GameRules.RULE_SPAWNER_BLOCKS_ENABLED) && (this.overridePeacefulAndMobSpawnRule || level.getDifficulty() != Difficulty.PEACEFUL && level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING));
    }

    public Optional<UUID> spawnMob(ServerLevel level, BlockPos pos) {
        Optional<UUID> var24;
        RandomSource random = level.getRandom();
        SpawnData nextSpawnData = this.data.getOrCreateNextSpawnData(this, level.getRandom());
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(() -> "spawner@" + String.valueOf(pos), LOGGER);){
            Object mob;
            SpawnData.CustomSpawnRules customSpawnRules;
            ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)level.registryAccess(), nextSpawnData.entityToSpawn());
            Optional<EntityType<?>> optional = EntityType.by(valueInput);
            if (optional.isEmpty()) {
                Optional<UUID> optional2 = Optional.empty();
                return optional2;
            }
            Vec3 vec3 = valueInput.read("Pos", Vec3.CODEC).orElseGet(() -> {
                TrialSpawnerConfig trialSpawnerConfig = this.activeConfig();
                return new Vec3((double)pos.getX() + (random.nextDouble() - random.nextDouble()) * (double)trialSpawnerConfig.spawnRange() + 0.5, pos.getY() + random.nextInt(3) - 1, (double)pos.getZ() + (random.nextDouble() - random.nextDouble()) * (double)trialSpawnerConfig.spawnRange() + 0.5);
            });
            if (!level.noCollision(optional.get().getSpawnAABB(vec3.x, vec3.y, vec3.z))) {
                Optional<UUID> optional3 = Optional.empty();
                return optional3;
            }
            if (!TrialSpawner.inLineOfSight(level, pos.getCenter(), vec3)) {
                Optional<UUID> optional4 = Optional.empty();
                return optional4;
            }
            BlockPos blockPos = BlockPos.containing(vec3);
            if (!SpawnPlacements.checkSpawnRules(optional.get(), level, EntitySpawnReason.TRIAL_SPAWNER, blockPos, level.getRandom())) {
                Optional<UUID> optional5 = Optional.empty();
                return optional5;
            }
            if (nextSpawnData.getCustomSpawnRules().isPresent() && !(customSpawnRules = nextSpawnData.getCustomSpawnRules().get()).isValidPosition(blockPos, level)) {
                Optional<UUID> optional6 = Optional.empty();
                return optional6;
            }
            Entity entity = EntityType.loadEntityRecursive(valueInput, (Level)level, EntitySpawnReason.TRIAL_SPAWNER, entity1 -> {
                entity1.snapTo(vec3.x, vec3.y, vec3.z, random.nextFloat() * 360.0f, 0.0f);
                return entity1;
            });
            if (entity == null) {
                Optional<UUID> optional7 = Optional.empty();
                return optional7;
            }
            if (entity instanceof Mob) {
                boolean flag;
                mob = (Mob)entity;
                if (!((Mob)mob).checkSpawnObstruction(level)) {
                    Optional<UUID> optional8 = Optional.empty();
                    return optional8;
                }
                boolean bl = flag = nextSpawnData.getEntityToSpawn().size() == 1 && nextSpawnData.getEntityToSpawn().getString("id").isPresent();
                if (flag) {
                    ((Mob)mob).finalizeSpawn(level, level.getCurrentDifficultyAt(((Entity)mob).blockPosition()), EntitySpawnReason.TRIAL_SPAWNER, null);
                }
                ((Mob)mob).setPersistenceRequired();
                nextSpawnData.getEquipment().ifPresent(arg_0 -> mob.equip(arg_0));
            }
            entity.spawnedViaMobSpawner = true;
            entity.spawnReason = CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER;
            if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, pos).isCancelled()) {
                mob = Optional.empty();
                return mob;
            }
            if (!level.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
                mob = Optional.empty();
                return mob;
            }
            FlameParticle flameParticle = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
            level.levelEvent(3011, pos, flameParticle.encode());
            level.levelEvent(3012, blockPos, flameParticle.encode());
            level.gameEvent(entity, GameEvent.ENTITY_PLACE, blockPos);
            var24 = Optional.of(entity.getUUID());
        }
        return var24;
    }

    public void ejectReward(ServerLevel level, BlockPos pos, ResourceKey<LootTable> lootTable) {
        LootTable lootTable1;
        LootTable sourceLootTable = lootTable1 = level.getServer().reloadableRegistries().getLootTable(lootTable);
        LootParams lootParams = new LootParams.Builder(level).create(LootContextParamSets.EMPTY);
        ObjectArrayList randomItems = lootTable1.getRandomItems(lootParams);
        if (!randomItems.isEmpty()) {
            BlockDispenseLootEvent spawnerDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(level, pos, null, randomItems, sourceLootTable);
            if (spawnerDispenseLootEvent.isCancelled()) {
                return;
            }
            randomItems = new ObjectArrayList(spawnerDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList());
            for (ItemStack itemStack : randomItems) {
                DefaultDispenseItemBehavior.spawnItem(level, itemStack, 2, Direction.UP, Vec3.atBottomCenterOf(pos).relative(Direction.UP, 1.2));
            }
            level.levelEvent(3014, pos, 0);
        }
    }

    public void tickClient(Level level, BlockPos pos, boolean isOminous) {
        RandomSource random;
        TrialSpawnerState state = this.getState();
        state.emitParticles(level, pos, isOminous);
        if (state.hasSpinningMob()) {
            double d = Math.max(0L, this.data.nextMobSpawnsAt - level.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + state.spinningMobSpeed() / (d + 200.0)) % 360.0;
        }
        if (state.isCapableOfSpawning() && (random = level.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent soundEvent = isOminous ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            level.playLocalSound(pos, soundEvent, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel level, BlockPos pos, boolean isOminous) {
        TrialSpawnerState trialSpawnerState;
        this.isOminous = isOminous;
        TrialSpawnerState state = this.getState();
        if (this.data.currentMobs.removeIf(mob -> TrialSpawner.shouldMobBeUntracked(level, pos, mob))) {
            this.data.nextMobSpawnsAt = level.getGameTime() + (long)this.activeConfig().ticksBetweenSpawn();
        }
        if ((trialSpawnerState = state.tickAndGetNext(pos, this, level)) != state) {
            this.setState(level, trialSpawnerState);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel level, BlockPos pos, UUID uuid) {
        Entity entity = level.getEntity(uuid);
        return entity == null || !entity.isAlive() || !entity.level().dimension().equals(level.dimension()) || entity.blockPosition().distSqr(pos) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level level, Vec3 spawnerPos, Vec3 mobPos) {
        BlockHitResult blockHitResult = level.clip(new ClipContext(mobPos, spawnerPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return blockHitResult.getBlockPos().equals(BlockPos.containing(spawnerPos)) || blockHitResult.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level level, BlockPos pos, RandomSource random, SimpleParticleType particleType) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d1 = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d2 = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            level.addParticle(ParticleTypes.SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
            level.addParticle(particleType, d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d1 = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d2 = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d3 = random.nextGaussian() * 0.02;
            double d4 = random.nextGaussian() * 0.02;
            double d5 = random.nextGaussian() * 0.02;
            level.addParticle(ParticleTypes.TRIAL_OMEN, d, d1, d2, d3, d4, d5);
            level.addParticle(ParticleTypes.SOUL_FIRE_FLAME, d, d1, d2, d3, d4, d5);
        }
    }

    public static void addDetectPlayerParticles(Level level, BlockPos pos, RandomSource random, int type, ParticleOptions particle) {
        for (int i = 0; i < 30 + Math.min(type, 10) * 5; ++i) {
            double d = (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
            double d2 = (double)pos.getX() + 0.5 + d;
            double d3 = (double)pos.getY() + 0.1 + (double)random.nextFloat() * 0.8;
            double d4 = (double)pos.getZ() + 0.5 + d1;
            level.addParticle(particle, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
            double d1 = (double)pos.getY() + 0.4 + random.nextDouble() * 0.2;
            double d2 = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
            double d3 = random.nextGaussian() * 0.02;
            double d4 = random.nextGaussian() * 0.02;
            double d5 = random.nextGaussian() * 0.02;
            level.addParticle(ParticleTypes.SMALL_FLAME, d, d1, d2, d3, d4, d5 * 0.25);
            level.addParticle(ParticleTypes.SMOKE, d, d1, d2, d3, d4, d5);
        }
    }

    public void overrideEntityToSpawn(EntityType<?> entityType, Level level) {
        this.data.reset();
        this.config = this.config.overrideEntity(entityType);
        this.setState(level, TrialSpawnerState.INACTIVE);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector playerDetector) {
        this.playerDetector = playerDetector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public record FullConfig(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous, int targetCooldownLength, int requiredPlayerRange) {
        public static final MapCodec<FullConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf("normal_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::normal), (App)TrialSpawnerConfig.CODEC.optionalFieldOf("ominous_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::ominous), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(FullConfig::targetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(FullConfig::requiredPlayerRange)).apply((Applicative)instance, FullConfig::new));
        public static final FullConfig DEFAULT = new FullConfig(Holder.direct(TrialSpawnerConfig.DEFAULT), Holder.direct(TrialSpawnerConfig.DEFAULT), 36000, 14);

        public FullConfig overrideEntity(EntityType<?> entity) {
            return new FullConfig(Holder.direct(this.normal.value().withSpawning(entity)), Holder.direct(this.ominous.value().withSpawning(entity)), this.targetCooldownLength, this.requiredPlayerRange);
        }

        public FullConfig overrideTargetCooldownLength(int targetCooldownLength) {
            return new FullConfig(this.normal, this.ominous, targetCooldownLength, this.requiredPlayerRange);
        }

        public FullConfig overrideRequiredPlayerRange(int requiredPlayerRange) {
            return new FullConfig(this.normal, this.ominous, this.targetCooldownLength, requiredPlayerRange);
        }

        public FullConfig overrideConfigs(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous) {
            return new FullConfig(normal, ominous, this.targetCooldownLength, this.requiredPlayerRange);
        }
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType particleType) {
            this.particleType = particleType;
        }

        public static FlameParticle decode(int id) {
            FlameParticle[] flameParticles = FlameParticle.values();
            return id <= flameParticles.length && id >= 0 ? flameParticles[id] : NORMAL;
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

