/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.phys.AABB;

public class SpikeFeature
extends Feature<SpikeConfiguration> {
    public static final int NUMBER_OF_SPIKES = 10;
    private static final int SPIKE_DISTANCE = 42;
    private static final LoadingCache<Long, List<EndSpike>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());

    public SpikeFeature(Codec<SpikeConfiguration> codec) {
        super(codec);
    }

    public static List<EndSpike> getSpikesForLevel(WorldGenLevel level) {
        RandomSource randomSource = RandomSource.create(level.getSeed());
        long l = randomSource.nextLong() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)l);
    }

    @Override
    public boolean place(FeaturePlaceContext<SpikeConfiguration> context) {
        SpikeConfiguration spikeConfiguration = context.config();
        WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        BlockPos blockPos = context.origin();
        List<EndSpike> spikes = spikeConfiguration.getSpikes();
        if (spikes.isEmpty()) {
            spikes = SpikeFeature.getSpikesForLevel(worldGenLevel);
        }
        for (EndSpike endSpike : spikes) {
            if (!endSpike.isCenterWithinChunk(blockPos)) continue;
            this.placeSpike(worldGenLevel, randomSource, spikeConfiguration, endSpike);
        }
        return true;
    }

    private void placeSpike(ServerLevelAccessor level, RandomSource random, SpikeConfiguration config, EndSpike spike) {
        EndCrystal endCrystal;
        int radius = spike.getRadius();
        for (BlockPos blockPos : BlockPos.betweenClosed(new BlockPos(spike.getCenterX() - radius, level.getMinY(), spike.getCenterZ() - radius), new BlockPos(spike.getCenterX() + radius, spike.getHeight() + 10, spike.getCenterZ() + radius))) {
            if (blockPos.distToLowCornerSqr(spike.getCenterX(), blockPos.getY(), spike.getCenterZ()) <= (double)(radius * radius + 1) && blockPos.getY() < spike.getHeight()) {
                this.setBlock(level, blockPos, Blocks.OBSIDIAN.defaultBlockState());
                continue;
            }
            if (blockPos.getY() <= 65) continue;
            this.setBlock(level, blockPos, Blocks.AIR.defaultBlockState());
        }
        if (spike.isGuarded()) {
            int i = -2;
            int i1 = 2;
            int i2 = 3;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i3 = -2; i3 <= 2; ++i3) {
                for (int i4 = -2; i4 <= 2; ++i4) {
                    for (int i5 = 0; i5 <= 3; ++i5) {
                        boolean flag2;
                        boolean flag = Mth.abs(i3) == 2;
                        boolean flag1 = Mth.abs(i4) == 2;
                        boolean bl = flag2 = i5 == 3;
                        if (!flag && !flag1 && !flag2) continue;
                        boolean flag3 = i3 == -2 || i3 == 2 || flag2;
                        boolean flag4 = i4 == -2 || i4 == 2 || flag2;
                        BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(CrossCollisionBlock.NORTH, flag3 && i4 != -2)).setValue(CrossCollisionBlock.SOUTH, flag3 && i4 != 2)).setValue(CrossCollisionBlock.WEST, flag4 && i3 != -2)).setValue(CrossCollisionBlock.EAST, flag4 && i3 != 2);
                        this.setBlock(level, mutableBlockPos.set(spike.getCenterX() + i3, spike.getHeight() + i5, spike.getCenterZ() + i4), blockState);
                    }
                }
            }
        }
        if ((endCrystal = EntityType.END_CRYSTAL.create(level.getLevel(), EntitySpawnReason.STRUCTURE)) != null) {
            endCrystal.setBeamTarget(config.getCrystalBeamTarget());
            endCrystal.setInvulnerable(config.isCrystalInvulnerable());
            endCrystal.snapTo((double)spike.getCenterX() + 0.5, spike.getHeight() + 1, (double)spike.getCenterZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            endCrystal.generatedByDragonFight = true;
            level.addFreshEntity(endCrystal);
            BlockPos blockPosx = endCrystal.blockPosition();
            this.setBlock(level, blockPosx.below(), Blocks.BEDROCK.defaultBlockState());
            this.setBlock(level, blockPosx, FireBlock.getState(level, blockPosx));
        }
    }

    public static class EndSpike {
        public static final Codec<EndSpike> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("centerX").orElse((Object)0).forGetter(endSpike -> endSpike.centerX), (App)Codec.INT.fieldOf("centerZ").orElse((Object)0).forGetter(endSpike -> endSpike.centerZ), (App)Codec.INT.fieldOf("radius").orElse((Object)0).forGetter(endSpike -> endSpike.radius), (App)Codec.INT.fieldOf("height").orElse((Object)0).forGetter(endSpike -> endSpike.height), (App)Codec.BOOL.fieldOf("guarded").orElse((Object)false).forGetter(endSpike -> endSpike.guarded)).apply((Applicative)instance, EndSpike::new));
        private final int centerX;
        private final int centerZ;
        private final int radius;
        private final int height;
        private final boolean guarded;
        private final AABB topBoundingBox;

        public EndSpike(int centerX, int centerZ, int radius, int height, boolean guarded) {
            this.centerX = centerX;
            this.centerZ = centerZ;
            this.radius = radius;
            this.height = height;
            this.guarded = guarded;
            this.topBoundingBox = new AABB(centerX - radius, -2032.0, centerZ - radius, centerX + radius, 2031.0, centerZ + radius);
        }

        public boolean isCenterWithinChunk(BlockPos pos) {
            return SectionPos.blockToSectionCoord(pos.getX()) == SectionPos.blockToSectionCoord(this.centerX) && SectionPos.blockToSectionCoord(pos.getZ()) == SectionPos.blockToSectionCoord(this.centerZ);
        }

        public int getCenterX() {
            return this.centerX;
        }

        public int getCenterZ() {
            return this.centerZ;
        }

        public int getRadius() {
            return this.radius;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isGuarded() {
            return this.guarded;
        }

        public AABB getTopBoundingBox() {
            return this.topBoundingBox;
        }
    }

    static class SpikeCacheLoader
    extends CacheLoader<Long, List<EndSpike>> {
        SpikeCacheLoader() {
        }

        public List<EndSpike> load(Long _long) {
            IntArrayList list = Util.toShuffledList(IntStream.range(0, 10), RandomSource.create(_long));
            ArrayList list1 = Lists.newArrayList();
            for (int i = 0; i < 10; ++i) {
                int floor = Mth.floor(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                int floor1 = Mth.floor(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                int i1 = list.get(i);
                int i2 = 2 + i1 / 3;
                int i3 = 76 + i1 * 3;
                boolean flag = i1 == 1 || i1 == 2;
                list1.add(new EndSpike(floor, floor1, i2, i3, flag));
            }
            return list1;
        }
    }
}

