/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.Version;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2BooleanMap;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2ObjectMap;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_STRUCTURE = -1;
    private final ChunkScanAccess storageAccess;
    private final RegistryAccess registryAccess;
    private final StructureTemplateManager structureTemplateManager;
    private final ResourceKey<LevelStem> dimension;
    private final ChunkGenerator chunkGenerator;
    private final RandomState randomState;
    private final LevelHeightAccessor heightAccessor;
    private final BiomeSource biomeSource;
    private final long seed;
    private final DataFixer fixerUpper;
    private static final int CHUNK_TOTAL_LIMIT = 2020050;
    private static final int PER_FEATURE_CHECK_LIMIT = 2020050;
    private final SynchronisedLong2ObjectMap<Object2IntMap<Structure>> loadedChunksSafe = new SynchronisedLong2ObjectMap(2020050);
    private final ConcurrentHashMap<Structure, SynchronisedLong2BooleanMap> featureChecksSafe = new ConcurrentHashMap();

    public StructureCheck(ChunkScanAccess storageAccess, RegistryAccess registryAccess, StructureTemplateManager structureTemplateManager, ResourceKey<LevelStem> dimension, ChunkGenerator chunkGenerator, RandomState randomState, LevelHeightAccessor heightAccessor, BiomeSource biomeSource, long seed, DataFixer fixerUpper) {
        this.storageAccess = storageAccess;
        this.registryAccess = registryAccess;
        this.structureTemplateManager = structureTemplateManager;
        this.dimension = dimension;
        this.chunkGenerator = chunkGenerator;
        this.randomState = randomState;
        this.heightAccessor = heightAccessor;
        this.biomeSource = biomeSource;
        this.seed = seed;
        this.fixerUpper = fixerUpper;
    }

    @Nullable
    private Integer getSaltOverride(Structure type) {
        LevelHeightAccessor levelHeightAccessor = this.heightAccessor;
        if (levelHeightAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelHeightAccessor;
            if (type instanceof MineshaftStructure) {
                return serverLevel.spigotConfig.mineshaftSeed;
            }
            if (type instanceof BuriedTreasureStructure) {
                return serverLevel.spigotConfig.buriedTreasureSeed;
            }
        }
        return null;
    }

    public StructureCheckResult checkStart(ChunkPos chunkPos, Structure structure, StructurePlacement placement, boolean skipKnownStructures) {
        long packedChunkPos = chunkPos.toLong();
        Object2IntMap<Structure> map = this.loadedChunksSafe.get(packedChunkPos);
        if (map != null) {
            return this.checkStructureInfo(map, structure, skipKnownStructures);
        }
        StructureCheckResult structureCheckResult = this.tryLoadFromStorage(chunkPos, structure, skipKnownStructures, packedChunkPos);
        if (structureCheckResult != null) {
            return structureCheckResult;
        }
        if (!placement.applyAdditionalChunkRestrictions(chunkPos.x, chunkPos.z, this.seed, this.getSaltOverride(structure))) {
            return StructureCheckResult.START_NOT_PRESENT;
        }
        boolean flag = this.featureChecksSafe.computeIfAbsent(structure, structure1 -> new SynchronisedLong2BooleanMap(2020050)).getOrCompute(packedChunkPos, l -> this.canCreateStructure(chunkPos, structure));
        return !flag ? StructureCheckResult.START_NOT_PRESENT : StructureCheckResult.CHUNK_LOAD_NEEDED;
    }

    private boolean canCreateStructure(ChunkPos chunkPos, Structure structure) {
        return structure.findValidGenerationPoint(new Structure.GenerationContext(this.registryAccess, this.chunkGenerator, this.biomeSource, this.randomState, this.structureTemplateManager, this.seed, chunkPos, this.heightAccessor, structure.biomes()::contains)).isPresent();
    }

    @Nullable
    private StructureCheckResult tryLoadFromStorage(ChunkPos chunkPos, Structure structure, boolean skipKnownStructures, long packedChunkPos) {
        CompoundTag compoundTag1;
        CollectFields collectFields = new CollectFields(new FieldSelector(IntTag.TYPE, "DataVersion"), new FieldSelector("Level", "Structures", CompoundTag.TYPE, "Starts"), new FieldSelector("structures", CompoundTag.TYPE, "starts"));
        try {
            this.storageAccess.scanChunk(chunkPos, collectFields).join();
        }
        catch (Exception var13) {
            LOGGER.warn("Failed to read chunk {}", (Object)chunkPos, (Object)var13);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Tag tag = collectFields.getResult();
        if (!(tag instanceof CompoundTag)) {
            return null;
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        int version = ChunkStorage.getVersion(compoundTag);
        if (version <= 1493) {
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        ChunkStorage.injectDatafixingContext(compoundTag, this.dimension, this.chunkGenerator.getTypeNameForDataFixer());
        try {
            compoundTag1 = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, compoundTag, version, Version.getCurrentVersion());
        }
        catch (Exception var12) {
            LOGGER.warn("Failed to partially datafix chunk {}", (Object)chunkPos, (Object)var12);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Object2IntMap<Structure> map = this.loadStructures(compoundTag1);
        if (map == null) {
            return null;
        }
        this.storeFullResults(packedChunkPos, map);
        return this.checkStructureInfo(map, structure, skipKnownStructures);
    }

    @Nullable
    private Object2IntMap<Structure> loadStructures(CompoundTag tag) {
        Optional optional = tag.getCompound("structures").flatMap(compoundTag1 -> compoundTag1.getCompound("starts"));
        if (optional.isEmpty()) {
            return null;
        }
        CompoundTag compoundTag = (CompoundTag)optional.get();
        if (compoundTag.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        HolderLookup.RegistryLookup registry = this.registryAccess.lookupOrThrow(Registries.STRUCTURE);
        compoundTag.forEach((arg_0, arg_1) -> StructureCheck.lambda$loadStructures$4((Registry)registry, (Object2IntMap)map, arg_0, arg_1));
        return map;
    }

    private static Object2IntMap<Structure> deduplicateEmptyMap(Object2IntMap<Structure> map) {
        return map.isEmpty() ? Object2IntMaps.emptyMap() : map;
    }

    private StructureCheckResult checkStructureInfo(Object2IntMap<Structure> structureChunks, Structure structure, boolean skipKnownStructures) {
        int orDefault = structureChunks.getOrDefault((Object)structure, -1);
        return orDefault == -1 || skipKnownStructures && orDefault != 0 ? StructureCheckResult.START_NOT_PRESENT : StructureCheckResult.START_PRESENT;
    }

    public void onStructureLoad(ChunkPos chunkPos, Map<Structure, StructureStart> chunkStarts) {
        long packedChunkPos = chunkPos.toLong();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        chunkStarts.forEach((arg_0, arg_1) -> StructureCheck.lambda$onStructureLoad$5((Object2IntMap)map, arg_0, arg_1));
        this.storeFullResults(packedChunkPos, (Object2IntMap<Structure>)map);
    }

    private void storeFullResults(long chunkPos, Object2IntMap<Structure> structureChunks) {
        this.loadedChunksSafe.put(chunkPos, StructureCheck.deduplicateEmptyMap(structureChunks));
        for (SynchronisedLong2BooleanMap value : this.featureChecksSafe.values()) {
            value.remove(chunkPos);
        }
    }

    public void incrementReference(ChunkPos pos, Structure structure) {
        this.loadedChunksSafe.compute(pos.toLong(), (_long, map) -> {
            if (map == null) {
                map = new Object2IntOpenHashMap();
            } else {
                Object2IntOpenHashMap object2IntOpenHashMap;
                if (map instanceof Object2IntOpenHashMap) {
                    Object2IntOpenHashMap fastClone = (Object2IntOpenHashMap)map;
                    object2IntOpenHashMap = fastClone.clone();
                } else {
                    object2IntOpenHashMap = new Object2IntOpenHashMap(map);
                }
                map = object2IntOpenHashMap;
            }
            map.computeInt((Object)structure, (structure1, integer) -> integer == null ? 1 : integer + 1);
            return map;
        });
    }

    private static /* synthetic */ void lambda$onStructureLoad$5(Object2IntMap map, Structure structure, StructureStart structureStart) {
        if (structureStart.isValid()) {
            map.put((Object)structure, structureStart.getReferences());
        }
    }

    private static /* synthetic */ void lambda$loadStructures$4(Registry registry, Object2IntMap map, String string, Tag tag1) {
        Structure structure;
        ResourceLocation resourceLocation = ResourceLocation.tryParse(string);
        if (resourceLocation != null && (structure = (Structure)registry.getValue(resourceLocation)) != null) {
            tag1.asCompound().ifPresent(compoundTag1 -> {
                String stringOr = compoundTag1.getStringOr("id", "");
                if (!"INVALID".equals(stringOr)) {
                    int intOr = compoundTag1.getIntOr("references", 0);
                    map.put((Object)structure, intOr);
                }
            });
        }
    }
}

