/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.Version;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Bukkit;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess levelStorageAccess, DataFixer fixerUpper) {
        this.fixerUpper = fixerUpper;
        this.playerDir = levelStorageAccess.getLevelPath(LevelResource.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(Player player) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(player.problemPath(), LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector, player.registryAccess());
            player.saveWithoutId(tagValueOutput);
            Path path = this.playerDir.toPath();
            Path path1 = Files.createTempFile(path, player.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            CompoundTag compoundTag = tagValueOutput.buildResult();
            NbtIo.writeCompressed(compoundTag, path1);
            Path path2 = path.resolve(player.getStringUUID() + ".dat");
            Path path3 = path.resolve(player.getStringUUID() + ".dat_old");
            Util.safeReplaceFile(path2, path1, path3);
        }
        catch (Exception var11) {
            LOGGER.warn("Failed to save player data for {}", (Object)player.getPlainTextName(), (Object)var11);
        }
    }

    private void backup(NameAndId nameAndId, String suffix) {
        Path path = this.playerDir.toPath();
        String string = nameAndId.id().toString();
        Path path1 = path.resolve(string + suffix);
        Path path2 = path.resolve(string + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + suffix);
        if (Files.isRegularFile(path1, new LinkOption[0])) {
            try {
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Exception var8) {
                LOGGER.warn("Failed to copy the player.dat file for {}", (Object)nameAndId.name(), (Object)var8);
            }
        }
    }

    private Optional<CompoundTag> load(NameAndId nameAndId, String suffix) {
        File file = new File(this.playerDir, nameAndId.id().toString() + suffix);
        boolean usingWrongFile = false;
        if (Bukkit.getOnlineMode() && !file.exists() && (file = new File(this.playerDir, String.valueOf(UUIDUtil.createOfflinePlayerUUID(nameAndId.name())) + suffix)).exists()) {
            usingWrongFile = true;
            LOGGER.warn("Using offline mode UUID file for player {} as it is the only copy we can find.", (Object)nameAndId.name());
        }
        if (file.exists() && file.isFile()) {
            try {
                Optional<CompoundTag> optional = Optional.of(NbtIo.readCompressed(file.toPath(), NbtAccounter.unlimitedHeap()));
                if (usingWrongFile) {
                    file.renameTo(new File(file.getPath() + ".offline-read"));
                }
                return optional;
            }
            catch (Exception var5) {
                LOGGER.warn("Failed to load player data for {}", (Object)nameAndId.name());
            }
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> load(NameAndId nameAndId) {
        Optional<CompoundTag> optional = this.load(nameAndId, ".dat");
        if (optional.isEmpty()) {
            this.backup(nameAndId, ".dat");
        }
        return optional.or(() -> this.load(nameAndId, ".dat_old")).map(compoundTag -> {
            int dataVersion = NbtUtils.getDataVersion(compoundTag, -1);
            return MCDataConverter.convertTag(MCTypeRegistry.PLAYER, compoundTag, dataVersion, Version.getCurrentVersion());
        });
    }

    public File getPlayerDir() {
        return this.playerDir;
    }
}

