/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyNameFunction
extends LootItemConditionalFunction {
    private static final ExtraCodecs.LateBoundIdMapper<String, Source> SOURCES = new ExtraCodecs.LateBoundIdMapper();
    public static final MapCodec<CopyNameFunction> CODEC;
    private final Source source;

    private CopyNameFunction(List<LootItemCondition> predicates, Source source) {
        super(predicates);
        this.source = source;
    }

    public LootItemFunctionType<CopyNameFunction> getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.param);
    }

    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        Object obj = context.getOptionalParameter(this.source.param);
        if (obj instanceof Nameable) {
            Nameable nameable = (Nameable)obj;
            stack.set(DataComponents.CUSTOM_NAME, nameable.getCustomName());
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> copyName(Source source) {
        return CopyNameFunction.simpleBuilder(conditions -> new CopyNameFunction((List<LootItemCondition>)conditions, source));
    }

    static {
        for (LootContext.EntityTarget entityTarget : LootContext.EntityTarget.values()) {
            SOURCES.put(entityTarget.getSerializedName(), new Source(entityTarget.getParam()));
        }
        for (Enum enum_ : LootContext.BlockEntityTarget.values()) {
            SOURCES.put(((LootContext.BlockEntityTarget)enum_).getSerializedName(), new Source(((LootContext.BlockEntityTarget)enum_).getParam()));
        }
        CODEC = RecordCodecBuilder.mapCodec(instance -> CopyNameFunction.commonFields(instance).and((App)SOURCES.codec((Codec<String>)Codec.STRING).fieldOf("source").forGetter(copyNameFunction -> copyNameFunction.source)).apply((Applicative)instance, CopyNameFunction::new));
    }

    public record Source(ContextKey<?> param) {
    }
}

