/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class ContextNbtProvider
implements NbtProvider {
    private static final ExtraCodecs.LateBoundIdMapper<String, Source<?>> SOURCES = new ExtraCodecs.LateBoundIdMapper();
    private static final Codec<Source<?>> GETTER_CODEC;
    public static final MapCodec<ContextNbtProvider> MAP_CODEC;
    public static final Codec<ContextNbtProvider> INLINE_CODEC;
    private final Source<?> source;

    private ContextNbtProvider(Source<?> source) {
        this.source = source;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.CONTEXT;
    }

    @Override
    @Nullable
    public Tag get(LootContext lootContext) {
        return this.source.get(lootContext);
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.contextParam());
    }

    public static NbtProvider forContextEntity(LootContext.EntityTarget entityTarget) {
        return new ContextNbtProvider(new EntitySource(entityTarget.getParam()));
    }

    static {
        for (LootContext.EntityTarget entityTarget : LootContext.EntityTarget.values()) {
            SOURCES.put(entityTarget.getSerializedName(), new EntitySource(entityTarget.getParam()));
        }
        for (Enum enum_ : LootContext.BlockEntityTarget.values()) {
            SOURCES.put(((LootContext.BlockEntityTarget)enum_).getSerializedName(), new BlockEntitySource(((LootContext.BlockEntityTarget)enum_).getParam()));
        }
        GETTER_CODEC = SOURCES.codec((Codec<String>)Codec.STRING);
        MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GETTER_CODEC.fieldOf("target").forGetter(contextNbtProvider -> contextNbtProvider.source)).apply((Applicative)instance, ContextNbtProvider::new));
        INLINE_CODEC = GETTER_CODEC.xmap(ContextNbtProvider::new, contextNbtProvider -> contextNbtProvider.source);
    }

    static interface Source<T> {
        public ContextKey<? extends T> contextParam();

        @Nullable
        public Tag get(T var1);

        @Nullable
        default public Tag get(LootContext context) {
            T optionalParameter = context.getOptionalParameter(this.contextParam());
            return optionalParameter != null ? this.get(optionalParameter) : null;
        }
    }

    record EntitySource(ContextKey<? extends Entity> contextParam) implements Source<Entity>
    {
        @Override
        public Tag get(Entity value) {
            return NbtPredicate.getEntityTagToCompare(value);
        }
    }

    record BlockEntitySource(ContextKey<? extends BlockEntity> contextParam) implements Source<BlockEntity>
    {
        @Override
        public Tag get(BlockEntity value) {
            return value.saveWithFullMetadata(value.getLevel().registryAccess());
        }
    }
}

