/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleLists;
import net.minecraft.world.phys.shapes.IndexMerger;

public class IndirectMerger
implements IndexMerger {
    private static final DoubleList EMPTY = DoubleLists.unmodifiable((DoubleList)DoubleArrayList.wrap((double[])new double[]{0.0}));
    private final double[] result;
    private final int[] firstIndices;
    private final int[] secondIndices;
    private final int resultLength;
    private static final int[] INFINITE_B_1 = new int[]{1, 1};
    private static final int[] INFINITE_B_0 = new int[]{0, 0};
    private static final int[] INFINITE_C = new int[]{0, 1};

    public IndirectMerger(DoubleList lower, DoubleList upper, boolean excludeUpper, boolean excludeLower) {
        double d = Double.NaN;
        int size = lower.size();
        int size1 = upper.size();
        int i = size + size1;
        double tail = lower.getDouble(size - 1);
        double head = lower.getDouble(0);
        if (!(head != Double.NEGATIVE_INFINITY || tail != Double.POSITIVE_INFINITY || excludeUpper || excludeLower || size != 2 && size != 4)) {
            this.result = upper.toDoubleArray();
            this.resultLength = upper.size();
            this.firstIndices = size == 2 ? INFINITE_B_0 : INFINITE_B_1;
            this.secondIndices = INFINITE_C;
            return;
        }
        this.result = new double[i];
        this.firstIndices = new int[i];
        this.secondIndices = new int[i];
        boolean flag = !excludeUpper;
        boolean flag1 = !excludeLower;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        while (true) {
            double d1;
            boolean flag4;
            boolean flag3;
            boolean flag2 = i2 >= size;
            boolean bl = flag3 = i3 >= size1;
            if (flag2 && flag3) {
                this.resultLength = Math.max(1, i1);
                return;
            }
            boolean bl2 = flag4 = !flag2 && (flag3 || lower.getDouble(i2) < upper.getDouble(i3) + 1.0E-7);
            if (flag4) {
                ++i2;
                if (flag && (i3 == 0 || flag3)) {
                    continue;
                }
            } else {
                ++i3;
                if (flag1 && (i2 == 0 || flag2)) continue;
            }
            int i4 = i2 - 1;
            int i5 = i3 - 1;
            double d2 = d1 = flag4 ? lower.getDouble(i4) : upper.getDouble(i5);
            if (!(d >= d1 - 1.0E-7)) {
                this.firstIndices[i1] = i4;
                this.secondIndices[i1] = i5;
                this.result[i1] = d1;
                ++i1;
                d = d1;
                continue;
            }
            this.firstIndices[i1 - 1] = i4;
            this.secondIndices[i1 - 1] = i5;
        }
    }

    @Override
    public boolean forMergedIndexes(IndexMerger.IndexConsumer consumer) {
        int i = this.resultLength - 1;
        for (int i1 = 0; i1 < i; ++i1) {
            if (consumer.merge(this.firstIndices[i1], this.secondIndices[i1], i1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.resultLength;
    }

    @Override
    public DoubleList getList() {
        return this.resultLength <= 1 ? EMPTY : DoubleArrayList.wrap((double[])this.result, (int)this.resultLength);
    }
}

