/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.phys.AABB;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Conduit;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.util.BoundingBox;

public class CraftConduit
extends CraftBlockEntityState<ConduitBlockEntity>
implements Conduit {
    public CraftConduit(World world, ConduitBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftConduit(CraftConduit state, Location location) {
        super(state, location);
    }

    @Override
    public CraftConduit copy() {
        return new CraftConduit(this, null);
    }

    @Override
    public CraftConduit copy(Location location) {
        return new CraftConduit(this, location);
    }

    public boolean isActive() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        return conduit != null && conduit.isActive();
    }

    public boolean isHunting() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        return conduit != null && conduit.isHunting();
    }

    public Collection<Block> getFrameBlocks() {
        this.ensureNoWorldGeneration();
        ArrayList<Block> blocks = new ArrayList<Block>();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        if (conduit != null) {
            for (BlockPos position : conduit.effectBlocks) {
                blocks.add(CraftBlock.at(this.getWorldHandle(), position));
            }
        }
        return blocks;
    }

    public int getFrameBlockCount() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        return conduit != null ? conduit.effectBlocks.size() : 0;
    }

    public int getRange() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        return conduit != null ? ConduitBlockEntity.getRange(conduit.effectBlocks) : 0;
    }

    public boolean setTarget(org.bukkit.entity.LivingEntity target) {
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        if (conduit == null) {
            return false;
        }
        EntityReference<LivingEntity> currentTarget = conduit.destroyTarget;
        if (target == null) {
            if (currentTarget == null) {
                return false;
            }
            conduit.destroyTarget = null;
        } else {
            if (currentTarget != null && target.getUniqueId().equals(currentTarget.getUUID())) {
                return false;
            }
            conduit.destroyTarget = EntityReference.of(((CraftLivingEntity)target).getHandle());
        }
        ConduitBlockEntity.updateAndAttackTarget(conduit.getLevel().getMinecraftWorld(), this.getPosition(), this.data, conduit, conduit.effectBlocks.size() >= 42, false);
        return true;
    }

    public org.bukkit.entity.LivingEntity getTarget() {
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        if (conduit == null) {
            return null;
        }
        LivingEntity nmsEntity = EntityReference.get(conduit.destroyTarget, this.getWorldHandle().getMinecraftWorld(), LivingEntity.class);
        return nmsEntity == null ? null : nmsEntity.getBukkitLivingEntity();
    }

    public boolean hasTarget() {
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getBlockEntityFromWorld();
        if (conduit == null) {
            return false;
        }
        LivingEntity destroyTarget = EntityReference.get(conduit.destroyTarget, this.getWorldHandle().getMinecraftWorld(), LivingEntity.class);
        return destroyTarget != null && destroyTarget.isAlive();
    }

    public BoundingBox getHuntingArea() {
        AABB bounds = ConduitBlockEntity.getDestroyRangeAABB(this.getPosition());
        return new BoundingBox(bounds.minX, bounds.minY, bounds.minZ, bounds.maxX, bounds.maxY, bounds.maxZ);
    }
}

