/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import ca.spottedleaf.concurrentutil.util.Priority;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.FoliaEntityScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.pointer.PointersSupplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftComplexPart;
import org.bukkit.craftbukkit.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public abstract class CraftEntity
implements Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    static final PointersSupplier<Entity> POINTERS_SUPPLIER;
    protected final CraftServer server;
    protected net.minecraft.world.entity.Entity entity;
    private final org.bukkit.entity.EntityType entityType;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public final io.papermc.paper.threadedregions.EntityScheduler taskScheduler = new io.papermc.paper.threadedregions.EntityScheduler(this);
    private final FoliaEntityScheduler apiScheduler = new FoliaEntityScheduler(this);
    private final Entity.Spigot spigot = new Entity.Spigot(this){

        public void sendMessage(BaseComponent component) {
        }

        public void sendMessage(BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    public final EntityScheduler getScheduler() {
        return this.apiScheduler;
    }

    public CraftEntity(CraftServer server, net.minecraft.world.entity.Entity entity) {
        this.server = server;
        this.entity = entity;
        this.entityType = CraftEntityType.minecraftToBukkit(entity.getType());
    }

    public static <T extends net.minecraft.world.entity.Entity> CraftEntity getEntity(CraftServer server, T entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Unknown entity");
        if (entity instanceof Player && !(entity instanceof ServerPlayer)) {
            return new CraftHumanEntity(server, (Player)entity);
        }
        if (entity instanceof EnderDragonPart) {
            EnderDragonPart complexPart = (EnderDragonPart)entity;
            if (complexPart.parentMob instanceof EnderDragon) {
                return new CraftEnderDragonPart(server, complexPart);
            }
            return new CraftComplexPart(server, complexPart);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(CraftEntityType.minecraftToBukkit(entity.getType()));
        if (entityTypeData != null) {
            return (CraftEntity)entityTypeData.convertFunction().apply(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + String.valueOf(entity == null ? null : entity.getClass())));
    }

    public net.minecraft.world.entity.Entity getHandle() {
        return this.entity;
    }

    public net.minecraft.world.entity.Entity getHandleRaw() {
        return this.entity;
    }

    public void setHandle(net.minecraft.world.entity.Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{uuid=" + String.valueOf(this.getUniqueId()) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.entity == other.entity;
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    public Location getLocation() {
        return CraftLocation.toBukkit(this.entity.position(), this.getWorld(), this.entity.getBukkitYaw(), this.entity.getXRot());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.getX());
            loc.setY(this.entity.getY());
            loc.setZ(this.entity.getZ());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.getXRot());
        }
        return loc;
    }

    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.getDeltaMovement());
    }

    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        if (!(this instanceof Projectile) && !(this instanceof Minecart) && CraftEntity.isUnsafeVelocity(velocity)) {
            CraftServer.excessiveVelEx = new Exception("Excessive velocity set detected: tried to set velocity of entity " + this.entity.getScoreboardName() + " id #" + this.getEntityId() + " to (" + velocity.getX() + "," + velocity.getY() + "," + velocity.getZ() + ").");
        }
        this.entity.setDeltaMovement(CraftVector.toVec3(velocity));
        this.entity.hurtMarked = true;
    }

    private static boolean isUnsafeVelocity(Vector vel) {
        double x = vel.getX();
        double y = vel.getY();
        double z = vel.getZ();
        return x > 4.0 || x < -4.0 || y > 4.0 || y < -4.0 || z > 4.0 || z < -4.0;
    }

    public double getHeight() {
        return this.getHandle().getBbHeight();
    }

    public double getWidth() {
        return this.getHandle().getBbWidth();
    }

    public BoundingBox getBoundingBox() {
        AABB bb = this.getHandle().getBoundingBox();
        return new BoundingBox(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
    }

    public boolean isOnGround() {
        net.minecraft.world.entity.Entity entity = this.entity;
        if (entity instanceof AbstractArrow) {
            AbstractArrow abstractArrow = (AbstractArrow)entity;
            return abstractArrow.isInGround();
        }
        return this.entity.onGround();
    }

    public boolean isInWater() {
        return this.entity.isInWater();
    }

    public World getWorld() {
        return this.entity.level().getWorld();
    }

    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite((float)pitch, (String)"pitch not finite");
        NumberConversions.checkFinite((float)yaw, (String)"yaw not finite");
        yaw = Location.normalizeYaw((float)yaw);
        pitch = Location.normalizePitch((float)pitch);
        this.getHandle().forceSetRotation(yaw, false, pitch, false);
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(location, cause, new TeleportFlag[0]);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... flags) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Target world cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
        location.checkFinite();
        return this.teleport0(location, cause, flags);
    }

    protected boolean teleport0(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... flags) {
        net.minecraft.world.entity.Entity entity = this.getHandle();
        if (!entity.isAlive() || !entity.valid) {
            return false;
        }
        EnumSet<Relative> relativeFlags = EnumSet.noneOf(Relative.class);
        for (TeleportFlag flag : flags) {
            if (!(flag instanceof TeleportFlag.Relative)) continue;
            TeleportFlag.Relative relativeFlag = (TeleportFlag.Relative)flag;
            relativeFlags.add(CraftEntity.deltaRelativeToNMS(relativeFlag));
        }
        return this.entity.teleport(new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3(location), Vec3.ZERO, location.getYaw(), location.getPitch(), relativeFlags, TeleportTransition.DO_NOTHING, cause)) != null;
    }

    public static Relative deltaRelativeToNMS(TeleportFlag.Relative apiFlag) {
        return switch (apiFlag) {
            default -> throw new MatchException(null, null);
            case TeleportFlag.Relative.VELOCITY_X -> Relative.DELTA_X;
            case TeleportFlag.Relative.VELOCITY_Y -> Relative.DELTA_Y;
            case TeleportFlag.Relative.VELOCITY_Z -> Relative.DELTA_Z;
            case TeleportFlag.Relative.VELOCITY_ROTATION -> Relative.ROTATE_DELTA;
        };
    }

    @Nullable
    public static TeleportFlag.Relative deltaRelativeToAPI(Relative nmsFlag) {
        return switch (nmsFlag) {
            default -> throw new MatchException(null, null);
            case Relative.DELTA_X -> TeleportFlag.Relative.VELOCITY_X;
            case Relative.DELTA_Y -> TeleportFlag.Relative.VELOCITY_Y;
            case Relative.DELTA_Z -> TeleportFlag.Relative.VELOCITY_Z;
            case Relative.ROTATE_DELTA -> TeleportFlag.Relative.VELOCITY_ROTATION;
            case Relative.X, Relative.Y, Relative.Z, Relative.Y_ROT, Relative.X_ROT -> null;
        };
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    public void lookAt(double x, double y, double z, LookAnchor entityAnchor) {
        this.getHandle().lookAt(CraftEntity.toNmsAnchor(entityAnchor), new Vec3(x, y, z));
    }

    public static EntityAnchorArgument.Anchor toNmsAnchor(LookAnchor nmsAnchor) {
        return switch (nmsAnchor) {
            default -> throw new MatchException(null, null);
            case LookAnchor.EYES -> EntityAnchorArgument.Anchor.EYES;
            case LookAnchor.FEET -> EntityAnchorArgument.Anchor.FEET;
        };
    }

    public static LookAnchor toApiAnchor(EntityAnchorArgument.Anchor playerAnchor) {
        return switch (playerAnchor) {
            default -> throw new MatchException(null, null);
            case EntityAnchorArgument.Anchor.EYES -> LookAnchor.EYES;
            case EntityAnchorArgument.Anchor.FEET -> LookAnchor.FEET;
        };
    }

    public List<Entity> getNearbyEntities(double x, double y, double z) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get nearby entities during world generation");
        AsyncCatcher.catchOp("getNearbyEntities");
        List<net.minecraft.world.entity.Entity> entities = this.getHandle().level().getEntities(this.entity, this.entity.getBoundingBox().inflate(x, y, z), (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> result = new ArrayList<Entity>(entities.size());
        for (net.minecraft.world.entity.Entity entity : entities) {
            result.add(entity.getBukkitEntity());
        }
        return result;
    }

    public int getEntityId() {
        return this.getHandle().getId();
    }

    public int getFireTicks() {
        return this.getHandle().getRemainingFireTicks();
    }

    public int getMaxFireTicks() {
        return this.getHandle().getFireImmuneTicks();
    }

    public void setFireTicks(int ticks) {
        this.getHandle().setRemainingFireTicks(ticks);
    }

    @Deprecated
    public void setVisualFire(boolean fire) {
        this.setVisualFire(fire ? TriState.TRUE : TriState.NOT_SET);
    }

    public void setVisualFire(TriState fire) {
        Preconditions.checkArgument((fire != null ? 1 : 0) != 0, (Object)"TriState cannot be null");
        this.getHandle().visualFire = fire;
    }

    public boolean isVisualFire() {
        return this.getVisualFire().toBooleanOrElse(false);
    }

    public TriState getVisualFire() {
        return this.getHandle().visualFire;
    }

    public int getFreezeTicks() {
        return this.getHandle().getTicksFrozen();
    }

    public int getMaxFreezeTicks() {
        return this.getHandle().getTicksRequiredToFreeze();
    }

    public void setFreezeTicks(int ticks) {
        Preconditions.checkArgument((0 <= ticks ? 1 : 0) != 0, (String)"Ticks (%s) cannot be less than 0", (int)ticks);
        this.getHandle().setTicksFrozen(ticks);
    }

    public boolean isFrozen() {
        return this.getHandle().isFullyFrozen();
    }

    public boolean isFreezeTickingLocked() {
        return this.entity.freezeLocked;
    }

    public void lockFreezeTicks(boolean locked) {
        this.entity.freezeLocked = locked;
    }

    public void remove() {
        this.entity.pluginRemoved = true;
        this.entity.discard(this.getHandle().generation ? null : EntityRemoveEvent.Cause.PLUGIN);
    }

    public boolean isDead() {
        return !this.entity.isAlive();
    }

    public boolean isValid() {
        return this.entity.isAlive() && this.entity.valid;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isPersistent() {
        return this.entity.persist;
    }

    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Entity getPassenger() {
        return this.isEmpty() ? null : this.getHandle().getPassengers().getFirst().getBukkitEntity();
    }

    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().startRiding(this.getHandle());
        }
        return false;
    }

    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform(this.getHandle().getPassengers(), net.minecraft.world.entity.Entity::getBukkitEntity));
    }

    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        return ((CraftEntity)passenger).getHandle().startRiding(this.getHandle(), true, true);
    }

    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        ((CraftEntity)passenger).getHandle().stopRiding();
        return true;
    }

    public boolean isEmpty() {
        return !this.getHandle().isVehicle();
    }

    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().ejectPassengers();
        return true;
    }

    public ItemStack getPickItemStack() {
        net.minecraft.world.item.ItemStack stack = this.getHandle().getPickResult();
        return stack == null ? ItemStack.empty() : stack.asBukkitCopy();
    }

    public float getFallDistance() {
        return (float)this.getHandle().fallDistance;
    }

    public void setFallDistance(float distance) {
        this.getHandle().fallDistance = distance;
    }

    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public UUID getUniqueId() {
        return this.entity.getUUID();
    }

    public int getTicksLived() {
        return this.getHandle().totalEntityAge;
    }

    public void setTicksLived(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Age value (%s) must be greater than 0", (int)value);
        this.getHandle().tickCount = value;
        this.getHandle().totalEntityAge = value;
    }

    public final org.bukkit.entity.EntityType getType() {
        return this.entityType;
    }

    public void playEffect(EntityEffect effect) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Entity effect cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot play effect during world generation");
        Preconditions.checkArgument((boolean)effect.isApplicableTo((Entity)this), (Object)"Entity effect cannot apply to this entity");
        this.getHandle().level().broadcastEntityEvent(this.getHandle(), effect.getData());
    }

    public Sound getSwimSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSound());
    }

    public Sound getSwimSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSplashSound());
    }

    public Sound getSwimHighSpeedSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimHighSpeedSplashSound());
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isInsideVehicle() {
        return this.getHandle().isPassenger();
    }

    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().stopRiding();
        return true;
    }

    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().getVehicle().getBukkitEntity();
    }

    public Component customName() {
        net.minecraft.network.chat.Component name = this.getHandle().getCustomName();
        return name != null ? PaperAdventure.asAdventure(name) : null;
    }

    public void customName(Component customName) {
        this.getHandle().setCustomName(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public Pointers pointers() {
        return POINTERS_SUPPLIER.view((Object)this);
    }

    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().setCustomName(CraftChatMessage.fromStringOrNull(name));
    }

    public String getCustomName() {
        net.minecraft.network.chat.Component name = this.getHandle().getCustomName();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    public void setCustomNameVisible(boolean flag) {
        this.getHandle().setCustomNameVisible(flag);
    }

    public boolean isCustomNameVisible() {
        return this.getHandle().isCustomNameVisible();
    }

    public void setVisibleByDefault(boolean visible) {
        if (this.getHandle().visibleByDefault != visible) {
            if (visible) {
                for (org.bukkit.entity.Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndShowEntity(this);
                }
            } else {
                for (org.bukkit.entity.Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndHideEntity(this);
                }
            }
            this.getHandle().visibleByDefault = visible;
        }
    }

    public boolean isVisibleByDefault() {
        return this.getHandle().visibleByDefault;
    }

    public Set<org.bukkit.entity.Player> getTrackedBy() {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get tracking players during world generation");
        ImmutableSet.Builder players = ImmutableSet.builder();
        ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)world.getChunkSource().chunkMap.entityMap.get(this.getEntityId());
        if (entityTracker != null) {
            for (ServerPlayerConnection connection : entityTracker.seenBy) {
                players.add((Object)connection.getPlayer().getBukkitEntity());
            }
        }
        return players.build();
    }

    public boolean isTrackedBy(org.bukkit.entity.Player player) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot check tracking players during world generation");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)world.getChunkSource().chunkMap.entityMap.get(this.getEntityId());
        if (entityTracker == null) {
            return false;
        }
        return entityTracker.seenBy.contains(((CraftPlayer)player).getHandle().connection);
    }

    public void sendMessage(String message) {
    }

    public void sendMessage(String ... messages) {
    }

    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().getName());
    }

    public @NotNull Component name() {
        return PaperAdventure.asAdventure(this.getHandle().getName());
    }

    public @NotNull Component teamDisplayName() {
        return PaperAdventure.asAdventure(this.getHandle().getDisplayName());
    }

    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    public void setGlowing(boolean flag) {
        this.getHandle().setGlowingTag(flag);
    }

    public boolean isGlowing() {
        return this.getHandle().isCurrentlyGlowing();
    }

    public void setInvulnerable(boolean flag) {
        this.getHandle().setInvulnerable(flag);
    }

    public boolean isInvulnerable() {
        return this.getHandle().isInvulnerableToBase(this.getHandle().damageSources().generic());
    }

    public boolean isSilent() {
        return this.getHandle().isSilent();
    }

    public void setSilent(boolean flag) {
        this.getHandle().setSilent(flag);
    }

    public boolean hasGravity() {
        return !this.getHandle().isNoGravity();
    }

    public void setGravity(boolean gravity) {
        this.getHandle().setNoGravity(!gravity);
    }

    public int getPortalCooldown() {
        return this.getHandle().getPortalCooldown();
    }

    public void setPortalCooldown(int cooldown) {
        this.getHandle().setPortalCooldown(cooldown);
    }

    public Set<String> getScoreboardTags() {
        return this.getHandle().getTags();
    }

    public boolean addScoreboardTag(String tag) {
        return this.getHandle().addTag(tag);
    }

    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().removeTag(tag);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getHandle().getPistonPushReaction().ordinal());
    }

    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().getMotionDirection());
    }

    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public Pose getPose() {
        return Pose.values()[this.getHandle().getPose().ordinal()];
    }

    public void setSneaking(boolean sneak) {
        this.getHandle().setShiftKeyDown(sneak);
    }

    public boolean isSneaking() {
        return this.getHandle().isShiftKeyDown();
    }

    public void setPose(Pose pose, boolean fixed) {
        Preconditions.checkArgument((pose != null ? 1 : 0) != 0, (Object)"pose cannot be null");
        this.setPose0(net.minecraft.world.entity.Pose.values()[pose.ordinal()], fixed);
    }

    public void setPose0(net.minecraft.world.entity.Pose pose, boolean fixed) {
        net.minecraft.world.entity.Entity handle = this.getHandle();
        handle.fixedPose = false;
        handle.setPose(pose);
        handle.fixedPose = fixed;
    }

    public boolean hasFixedPose() {
        return this.getHandle().fixedPose;
    }

    public SpawnCategory getSpawnCategory() {
        return CraftSpawnCategory.toBukkit(this.getHandle().getType().getCategory());
    }

    public boolean isInWorld() {
        return this.getHandle().inWorld;
    }

    public String getAsString() {
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "Entity#toString", LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext(problemReporter, this.getHandle().registryAccess());
            if (!this.getHandle().saveAsPassenger(output, false, true, true)) {
                String string = null;
                return string;
            }
            String string = output.buildResult().toString();
            return string;
        }
    }

    public EntitySnapshot createSnapshot() {
        return CraftEntitySnapshot.create(this);
    }

    public Entity copy() {
        net.minecraft.world.entity.Entity copy = this.copy(this.getHandle().level());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        return copy.getBukkitEntity();
    }

    public Entity copy(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity copy = this.copy(((CraftWorld)location.getWorld()).getHandle());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        copy.setPos(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)copy.getBukkitEntity());
    }

    private net.minecraft.world.entity.Entity copy(Level level) {
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "Entity#copy", LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext(problemReporter, level.registryAccess());
            this.getHandle().saveAsPassenger(output, false, true, true);
            net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(output.buildResult(), level, EntitySpawnReason.LOAD, Function.identity());
            return entity;
        }
    }

    public void storeBukkitValues(ValueOutput output) {
        if (!this.persistentDataContainer.isEmpty()) {
            output.store("BukkitValues", CompoundTag.CODEC, this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(ValueInput input) {
        input.read("BukkitValues", CompoundTag.CODEC).ifPresent(this.persistentDataContainer::putAll);
    }

    protected CompoundTag save() {
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "Entity#save", LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext(problemReporter, this.getHandle().registryAccess());
            tagValueOutput.putString("id", this.getHandle().getEncodeId(true));
            this.getHandle().saveWithoutId(tagValueOutput);
            CompoundTag compoundTag = tagValueOutput.buildResult();
            return compoundTag;
        }
    }

    protected void update() {
        if (!this.getHandle().isAlive()) {
            return;
        }
        ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)world.getChunkSource().chunkMap.entityMap.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        for (ServerPlayerConnection connection : entityTracker.seenBy) {
            this.getHandle().resendPossiblyDesyncedEntityData(connection.getPlayer());
        }
    }

    public void update(ServerPlayer player) {
        if (!this.getHandle().isAlive()) {
            return;
        }
        ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)world.getChunkSource().chunkMap.entityMap.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        player.connection.send(this.getHandle().getAddEntityPacket(entityTracker.serverEntity));
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                public boolean isOp() {
                    return false;
                }

                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    public CompletableFuture<Boolean> teleportAsync(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... teleportFlags) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Target world cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
        location.checkFinite();
        Location locationClone = location.clone();
        ServerLevel world = ((CraftWorld)locationClone.getWorld()).getHandle();
        CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
        world.loadChunksForMoveAsync(this.getHandle().getBoundingBoxAt(locationClone.getX(), locationClone.getY(), locationClone.getZ()), this instanceof CraftPlayer ? Priority.HIGHER : Priority.NORMAL, chunks -> MinecraftServer.getServer().scheduleOnMain(() -> {
            ServerChunkCache chunkCache = world.getChunkSource();
            for (ChunkAccess chunk : chunks) {
                chunkCache.addTicketAtLevel(TicketType.POST_TELEPORT, chunk.getPos(), 33);
            }
            try {
                ret.complete(this.teleport0(locationClone, cause, teleportFlags) ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (Throwable throwable) {
                MinecraftServer.LOGGER.error("Failed to teleport entity {}", (Object)this, (Object)throwable);
                ret.completeExceptionally(throwable);
            }
        }));
        return ret;
    }

    public Entity.Spigot spigot() {
        return this.spigot;
    }

    public Location getOrigin() {
        if (this.getHandle().origin == null) {
            return null;
        }
        World world = this.getWorld();
        if (this.getHandle().originWorld != null) {
            world = Bukkit.getWorld((UUID)this.getHandle().originWorld);
        }
        return CraftVector.toBukkit(this.getHandle().origin).toLocation(world);
    }

    public boolean fromMobSpawner() {
        return this.getHandle().spawnedViaMobSpawner;
    }

    public CreatureSpawnEvent.SpawnReason getEntitySpawnReason() {
        return this.getHandle().spawnReason;
    }

    public boolean isUnderWater() {
        return this.getHandle().isUnderWater();
    }

    public boolean isInRain() {
        return this.getHandle().isInRain();
    }

    public boolean isInLava() {
        return this.getHandle().isInLava();
    }

    public boolean isTicking() {
        return this.getHandle().isTicking();
    }

    public Set<org.bukkit.entity.Player> getTrackedPlayers() {
        ChunkMap.TrackedEntity tracker;
        ServerLevel world = (ServerLevel)this.entity.level();
        ChunkMap.TrackedEntity trackedEntity = tracker = world == null ? null : (ChunkMap.TrackedEntity)world.getChunkSource().chunkMap.entityMap.get(this.entity.getId());
        if (tracker == null) {
            return Collections.emptySet();
        }
        HashSet<org.bukkit.entity.Player> set = new HashSet<org.bukkit.entity.Player>(tracker.seenBy.size());
        for (ServerPlayerConnection connection : tracker.seenBy) {
            set.add(connection.getPlayer().getBukkitEntity().getPlayer());
        }
        return set;
    }

    public boolean spawnAt(Location location, CreatureSpawnEvent.SpawnReason reason) {
        boolean spawned;
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkNotNull((Object)reason, (Object)"reason cannot be null");
        this.entity.setLevel(((CraftWorld)location.getWorld()).getHandle());
        this.entity.setPos(location.getX(), location.getY(), location.getZ());
        this.entity.setRot(location.getYaw(), location.getPitch());
        boolean bl = spawned = !this.entity.valid && this.entity.level().addFreshEntity(this.entity, reason);
        if (!spawned) {
            return false;
        }
        this.entity.getIndirectPassengers().forEach(e -> e.level().addFreshEntity((net.minecraft.world.entity.Entity)e, reason));
        return true;
    }

    public boolean isInPowderedSnow() {
        return this.getHandle().isInPowderSnow || this.getHandle().wasInPowderSnow;
    }

    public double getX() {
        return this.entity.getX();
    }

    public double getY() {
        return this.entity.getY();
    }

    public double getZ() {
        return this.entity.getZ();
    }

    public float getPitch() {
        return this.entity.getXRot();
    }

    public float getYaw() {
        return this.entity.getBukkitYaw();
    }

    public boolean isInvisible() {
        return this.getHandle().isInvisible();
    }

    public void setInvisible(boolean invisible) {
        this.getHandle().persistentInvisibility = invisible;
        this.getHandle().setSharedFlag(5, invisible);
    }

    public void setNoPhysics(boolean noPhysics) {
        this.getHandle().noPhysics = noPhysics;
    }

    public boolean hasNoPhysics() {
        return this.getHandle().noPhysics;
    }

    public boolean collidesAt(@NotNull Location location) {
        AABB box = this.getHandle().getBoundingBoxAt(location.getX(), location.getY(), location.getZ());
        return !this.getHandle().level().noCollision(this.getHandle(), box);
    }

    public boolean wouldCollideUsing(@NotNull BoundingBox boundingBox) {
        AABB box = new AABB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        return !this.getHandle().level().noCollision(this.getHandle(), box);
    }

    public String getScoreboardEntryName() {
        return this.getHandle().getScoreboardName();
    }

    public void broadcastHurtAnimation(Collection<org.bukkit.entity.Player> players) {
        Preconditions.checkArgument((!players.contains(this) ? 1 : 0) != 0, (Object)"Cannot broadcast hurt animation to self without a yaw");
        for (org.bukkit.entity.Player player : players) {
            ((CraftPlayer)player).sendHurtAnimation(0.0f, this);
        }
    }

    @Nullable
    public <T> T getData(@NotNull DataComponentType.Valued<T> type) {
        return this.entity.get(PaperDataComponentType.bukkitToMinecraft(type));
    }

    @Nullable
    public <T> T getDataOrDefault(@NotNull DataComponentType.Valued<? extends T> type, @Nullable T fallback) {
        return this.entity.getOrDefault(PaperDataComponentType.bukkitToMinecraft(type), fallback);
    }

    public boolean hasData(@NotNull DataComponentType type) {
        return this.entity.get(PaperDataComponentType.bukkitToMinecraft(type)) != null;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        POINTERS_SUPPLIER = (PointersSupplier)PointersSupplier.builder().resolving(Identity.DISPLAY_NAME, CommandSender::name).resolving(Identity.UUID, Entity::getUniqueId).resolving(PermissionChecker.POINTER, entity1 -> arg_0 -> ((Entity)entity1).permissionValue(arg_0)).build();
    }
}

