/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.entity.Pig;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftPig
extends CraftAnimals
implements org.bukkit.entity.Pig {
    public CraftPig(CraftServer server, Pig entity) {
        super(server, entity);
    }

    @Override
    public Pig getHandle() {
        return (Pig)this.entity;
    }

    public boolean hasSaddle() {
        return this.getHandle().isSaddled();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().setItemSlot(EquipmentSlot.SADDLE, saddled ? new ItemStack(Items.SADDLE) : ItemStack.EMPTY);
    }

    public int getBoostTicks() {
        return this.getHandle().steering.boosting ? this.getHandle().steering.boostTimeTotal() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().steering.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().steering.boosting ? this.getHandle().steering.boostTime : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().steering.boosting) {
            return;
        }
        int max = this.getHandle().steering.boostTimeTotal();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %s (inclusive)", (int)max);
        this.getHandle().steering.boostTime = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    public Pig.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().getVariant());
    }

    public void setVariant(Pig.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().setVariant(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends HolderableBase<PigVariant>
    implements Pig.Variant {
        public static Pig.Variant minecraftToBukkit(PigVariant minecraft) {
            return (Pig.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.PIG_VARIANT);
        }

        public static Pig.Variant minecraftHolderToBukkit(Holder<PigVariant> minecraft) {
            return (Pig.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.PIG_VARIANT);
        }

        public static PigVariant bukkitToMinecraft(Pig.Variant bukkit) {
            return (PigVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<PigVariant> bukkitToMinecraftHolder(Pig.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftVariant(Holder<PigVariant> holder) {
            super(holder);
        }
    }
}

