/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Direction;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.AbstractProjectile;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.util.Vector;

public class CraftShulkerBullet
extends AbstractProjectile
implements ShulkerBullet {
    public CraftShulkerBullet(CraftServer server, net.minecraft.world.entity.projectile.ShulkerBullet entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.projectile.ShulkerBullet getHandle() {
        return (net.minecraft.world.entity.projectile.ShulkerBullet)this.entity;
    }

    public Entity getTarget() {
        return this.getHandle().getTarget() != null ? this.getHandle().getTarget().getBukkitEntity() : null;
    }

    public void setTarget(Entity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        this.getHandle().setTarget(target == null ? null : ((CraftEntity)target).getHandle());
    }

    public Vector getTargetDelta() {
        net.minecraft.world.entity.projectile.ShulkerBullet bullet = this.getHandle();
        return new Vector(bullet.targetDeltaX, bullet.targetDeltaY, bullet.targetDeltaZ);
    }

    public void setTargetDelta(Vector vector) {
        net.minecraft.world.entity.projectile.ShulkerBullet bullet = this.getHandle();
        bullet.targetDeltaX = vector.getX();
        bullet.targetDeltaY = vector.getY();
        bullet.targetDeltaZ = vector.getZ();
    }

    public BlockFace getCurrentMovementDirection() {
        Direction dir = this.getHandle().currentMoveDirection;
        if (dir == null) {
            return null;
        }
        return CraftBlock.notchToBlockFace(dir);
    }

    public void setCurrentMovementDirection(BlockFace movementDirection) {
        this.getHandle().currentMoveDirection = CraftBlock.blockFaceToNotch(movementDirection);
    }

    public int getFlightSteps() {
        return this.getHandle().flightSteps;
    }

    public void setFlightSteps(int steps) {
        this.getHandle().flightSteps = steps;
    }
}

