/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.util.WeakCollection;
import org.bukkit.scoreboard.ScoreboardManager;
import org.spigotmc.AsyncCatcher;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer server, Scoreboard scoreboard) {
        this.mainScoreboard = new CraftScoreboard(scoreboard);
        this.mainScoreboard.registeredGlobally = true;
        this.server = server;
        this.scoreboards.add(this.mainScoreboard);
    }

    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    public CraftScoreboard getNewScoreboard() {
        AsyncCatcher.catchOp("scoreboard creation");
        CraftScoreboard scoreboard = new CraftScoreboard(new ServerScoreboard(this.server));
        if (GlobalConfiguration.get().scoreboards.trackPluginScoreboards) {
            scoreboard.registeredGlobally = true;
            this.scoreboards.add(scoreboard);
        }
        return scoreboard;
    }

    public void registerScoreboardForVanilla(CraftScoreboard scoreboard) {
        AsyncCatcher.catchOp("scoreboard registration");
        this.scoreboards.add(scoreboard);
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, CraftScoreboard scoreboard) {
        Scoreboard newBoard;
        Scoreboard oldBoard = this.getPlayerBoard(player).getHandle();
        if (oldBoard == (newBoard = scoreboard.getHandle())) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        ServerPlayer serverPlayer = player.getHandle();
        HashSet<Objective> removed = new HashSet<Objective>();
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            Objective objective = oldBoard.getDisplayObjective(displaySlot);
            if (objective == null || removed.contains(objective)) continue;
            serverPlayer.connection.send(new ClientboundSetObjectivePacket(objective, 1));
            removed.add(objective);
        }
        for (PlayerTeam team : oldBoard.getPlayerTeams()) {
            serverPlayer.connection.send(ClientboundSetPlayerTeamPacket.createRemovePacket(team));
        }
        this.server.getPlayerList().updateEntireScoreboard((ServerScoreboard)newBoard, player.getHandle());
    }

    public void removePlayer(CraftPlayer player) {
        this.playerBoards.remove(player);
    }

    public void forAllObjectives(ObjectiveCriteria criteria, ScoreHolder holder, Consumer<ScoreAccess> consumer) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            scoreboard.getHandle().forAllObjectives(criteria, holder, consumer);
        }
    }
}

