/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;

public final class CraftLocation {
    private CraftLocation() {
    }

    public static Location toBukkit(Vec3 pos) {
        return CraftLocation.toBukkit(pos, (World)null);
    }

    public static Location toBukkit(Vec3 pos, World world) {
        return CraftLocation.toBukkit(pos, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(Vec3 pos, World world, float yaw, float pitch) {
        return new Location(world, pos.x(), pos.y(), pos.z(), yaw, pitch);
    }

    public static Location toBukkit(Vec3 pos, Level level) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld());
    }

    public static Location toBukkit(Vec3 pos, Level level, float yaw, float pitch) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld(), yaw, pitch);
    }

    public static Location toBukkit(Vec3i pos) {
        return CraftLocation.toBukkit(pos, (World)null);
    }

    public static Location toBukkit(Vec3i pos, World world) {
        return CraftLocation.toBukkit(pos, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(Vec3i pos, World world, float yaw, float pitch) {
        return new Location(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), yaw, pitch);
    }

    public static Location toBukkit(Vec3i pos, Level level) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld());
    }

    public static Location toBukkit(Vec3i pos, Level level, float yaw, float pitch) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld(), yaw, pitch);
    }

    public static Location toBukkit(Node point, Level level) {
        return new Location((World)level.getWorld(), (double)point.x, (double)point.y, (double)point.z);
    }

    public static BlockPos toBlockPosition(Location loc) {
        return new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static GlobalPos toGlobalPos(Location loc) {
        return GlobalPos.of(((CraftWorld)loc.getWorld()).getHandle().dimension(), CraftLocation.toBlockPosition(loc));
    }

    public static Location fromGlobalPos(GlobalPos globalPos) {
        return CraftLocation.toBukkit((Vec3i)globalPos.pos(), (Level)MinecraftServer.getServer().getLevel(globalPos.dimension()));
    }

    public static Vec3 toVec3(Location loc) {
        return new Vec3(loc.getX(), loc.getY(), loc.getZ());
    }
}

