/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.destroystokyo.paper.PaperVersionFetcher;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.attribute.UnmodifiableAttributeMap;
import io.papermc.paper.entity.EntitySerializationFlag;
import io.papermc.paper.inventory.tooltip.TooltipContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.PaperLifecycleEventManager;
import io.papermc.paper.pluginremap.reflect.ReflectionRemapper;
import io.papermc.paper.registry.RegistryKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.damage.CraftDamageSourceBuilder;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.legacy.CraftLegacy;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.potion.CraftPotionType;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.Commodore;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class CraftMagicNumbers
implements UnsafeValues {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CraftMagicNumbers INSTANCE = new CraftMagicNumbers();
    public static final boolean DISABLE_OLD_API_SUPPORT = Boolean.getBoolean("paper.disableOldApiSupport");
    private final Commodore commodore = new Commodore();
    private static final Map<Block, Material> BLOCK_MATERIAL = new HashMap<Block, Material>();
    private static final Map<Item, Material> ITEM_MATERIAL = new HashMap<Item, Material>();
    private static final Map<Material, Item> MATERIAL_ITEM = new HashMap<Material, Item>();
    private static final Map<Material, Block> MATERIAL_BLOCK = new HashMap<Material, Block>();
    private static final TagParser<Tag> SNBT_REGISTRY_UNAWARE_PARSER;

    private CraftMagicNumbers() {
    }

    public ComponentFlattener componentFlattener() {
        return PaperAdventure.FLATTENER;
    }

    public GsonComponentSerializer colorDownsamplingGsonComponentSerializer() {
        return GsonComponentSerializer.colorDownsamplingGson();
    }

    public GsonComponentSerializer gsonComponentSerializer() {
        return GsonComponentSerializer.gson();
    }

    public PlainComponentSerializer plainComponentSerializer() {
        return PaperAdventure.PLAIN;
    }

    public PlainTextComponentSerializer plainTextSerializer() {
        return PlainTextComponentSerializer.plainText();
    }

    public LegacyComponentSerializer legacyComponentSerializer() {
        return LegacyComponentSerializer.legacySection();
    }

    public Component resolveWithContext(Component component, CommandSender context, Entity scoreboardSubject, boolean bypassPermissions) throws IOException {
        return PaperAdventure.resolveWithContext(component, context, scoreboardSubject, bypassPermissions);
    }

    public static BlockState getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static BlockState getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(BlockState data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.getBlock())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static Item getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(Item item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(Block block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(Item item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static Item getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static Block getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static byte toLegacyData(BlockState data) {
        return CraftLegacy.toLegacyData(data);
    }

    public Commodore getCommodore() {
        return this.commodore;
    }

    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial((String)material);
        }
        Dynamic<StringTag> name = new Dynamic<StringTag>(NbtOps.INSTANCE, StringTag.valueOf("minecraft:" + material.toLowerCase(Locale.ROOT)));
        if (name.equals((Object)(converted = DataFixers.getDataFixer().update(References.ITEM_NAME, name, version, this.getDataVersion())))) {
            converted = DataFixers.getDataFixer().update(References.BLOCK_NAME, name, version, this.getDataVersion());
        }
        return Material.matchMaterial((String)converted.asString(""));
    }

    @Deprecated(forRemoval=true, since="1.21.6")
    public String getMappingsVersion() {
        throw new UnsupportedOperationException("Use ServerBuildInfo#minecraftVersionId instead.");
    }

    public int getDataVersion() {
        return SharedConstants.getCurrentVersion().dataVersion().version();
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.applyComponents(new ItemParser(Commands.createValidationContext(CraftRegistry.getMinecraftRegistry())).parse(new StringReader(arguments)).components());
        }
        catch (CommandSyntaxException ex) {
            LogUtils.getClassLogger().error("Exception modifying ItemStack", new Throwable(ex));
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(MinecraftServer.getServer().getWorldPath(LevelResource.DATAPACK_DIR).toFile(), "bukkit");
    }

    public org.bukkit.advancement.Advancement loadAdvancement(NamespacedKey key, String advancement) {
        Preconditions.checkArgument((Bukkit.getAdvancement((NamespacedKey)key) == null ? 1 : 0) != 0, (String)"Advancement %s already exists", (Object)key);
        ResourceLocation resourceKey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = JsonParser.parseString((String)advancement);
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().createSerializationContext(JsonOps.INSTANCE);
        Advancement nms = (Advancement)Advancement.CODEC.parse(ops, (Object)jsonelement).getOrThrow(JsonParseException::new);
        if (nms != null) {
            org.bukkit.advancement.Advancement bukkit;
            AdvancementNode root;
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            mapBuilder.putAll(MinecraftServer.getServer().getAdvancements().advancements);
            AdvancementHolder holder = new AdvancementHolder(resourceKey, nms);
            mapBuilder.put((Object)resourceKey, (Object)holder);
            MinecraftServer.getServer().getAdvancements().advancements = mapBuilder.build();
            AdvancementTree tree = MinecraftServer.getServer().getAdvancements().tree();
            tree.addAll(List.of(holder));
            AdvancementNode node = tree.get(resourceKey);
            if (node != null && (root = node.root()).holder().value().display().isPresent()) {
                TreeNodePosition.run(root);
            }
            if ((bukkit = Bukkit.getAdvancement((NamespacedKey)key)) != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + String.valueOf(key), ex);
                }
                MinecraftServer.getServer().getPlayerList().getPlayers().forEach(player -> {
                    player.getAdvancements().reload(MinecraftServer.getServer().getAdvancements());
                    player.getAdvancements().flushDirty((ServerPlayer)player, false);
                });
                return bukkit;
            }
        }
        return null;
    }

    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    public void checkSupported(PluginDescriptionFile descriptionFile) throws InvalidPluginException {
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(descriptionFile.getAPIVersion());
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        if (toCheck.isNewerThan(ApiVersion.CURRENT)) {
            throw new InvalidPluginException("Unsupported API version " + descriptionFile.getAPIVersion());
        }
        if (toCheck.isOlderThan(minimumVersion)) {
            throw new InvalidPluginException("Plugin API version " + descriptionFile.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
        if (!DISABLE_OLD_API_SUPPORT && toCheck.isOlderThan(ApiVersion.FLATTENING)) {
            CraftLegacy.init();
        }
        if (toCheck == ApiVersion.NONE) {
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + descriptionFile.getFullName() + " does not specify an api-version.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        if (DISABLE_OLD_API_SUPPORT) {
            return ReflectionRemapper.processClass(clazz);
        }
        try {
            clazz = this.commodore.convert(clazz, pdf.getName(), ApiVersion.getOrCreateVersion(pdf.getAPIVersion()), ((CraftServer)Bukkit.getServer()).activeCompatibilities);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        ItemType item = material.asItemType();
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)(String.valueOf(material) + " is not an item and does not have default attributes"));
        return item.getDefaultAttributeModifiers(slot);
    }

    public CreativeCategory getCreativeCategory(Material material) {
        return material.getCreativeCategory();
    }

    public String getBlockTranslationKey(Material material) {
        return material.getBlockTranslationKey();
    }

    public String getItemTranslationKey(Material material) {
        return material.getItemTranslationKey();
    }

    public String getTranslationKey(org.bukkit.entity.EntityType entityType) {
        Preconditions.checkArgument((entityType.getName() != null ? 1 : 0) != 0, (String)"Invalid name of EntityType %s for translation key", (Object)entityType);
        return EntityType.byString(entityType.getName()).map(EntityType::getDescriptionId).orElseThrow();
    }

    public String getTranslationKey(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        return nmsItemStack.getItem().getDescriptionId();
    }

    public boolean isSupportedApiVersion(String apiVersion) {
        if (apiVersion == null) {
            return false;
        }
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(apiVersion);
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        return !toCheck.isNewerThan(ApiVersion.CURRENT) && !toCheck.isOlderThan(minimumVersion);
    }

    public String getTranslationKey(Attribute attribute) {
        return attribute.getTranslationKey();
    }

    public PotionType.InternalPotionData getInternalPotionData(NamespacedKey namespacedKey) {
        Potion potionRegistry = CraftRegistry.getMinecraftRegistry(Registries.POTION).getOptional(CraftNamespacedKey.toMinecraft(namespacedKey)).orElseThrow();
        return new CraftPotionType(namespacedKey, potionRegistry);
    }

    public DamageSource.Builder createDamageSourceBuilder(DamageType damageType) {
        return new CraftDamageSourceBuilder(damageType);
    }

    public String get(Class<?> aClass, String s) {
        if (aClass == Enchantment.class) {
            return FieldRename.convertEnchantmentName(ApiVersion.CURRENT, s);
        }
        return s;
    }

    public <B extends Keyed> B get(RegistryKey<B> registry, NamespacedKey namespacedKey) {
        return CraftRegistry.get(registry, namespacedKey, ApiVersion.CURRENT);
    }

    public VersionFetcher getVersionFetcher() {
        return new PaperVersionFetcher();
    }

    public byte[] serializeItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"null cannot be serialized");
        Preconditions.checkArgument((!item.isEmpty() ? 1 : 0) != 0, (Object)"Empty itemstack cannot be serialized");
        return this.serializeNbtToBytes((CompoundTag)net.minecraft.world.item.ItemStack.CODEC.encodeStart(MinecraftServer.getServer().registryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)CraftItemStack.unwrap(item)).getOrThrow());
    }

    public ItemStack deserializeItem(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        CompoundTag compound = this.deserializeNbtFromBytes(data);
        return this.deserializeItem(compound);
    }

    private ItemStack deserializeItem(CompoundTag compound) {
        int dataVersion = compound.getIntOr("DataVersion", 0);
        compound = PlatformHooks.get().convertNBT(References.ITEM_STACK, DataFixers.getDataFixer(), compound, dataVersion, this.getDataVersion());
        if (compound.getStringOr("id", "minecraft:air").equals("minecraft:air")) {
            return CraftItemStack.asCraftMirror(net.minecraft.world.item.ItemStack.EMPTY);
        }
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse(CraftRegistry.getMinecraftRegistry().createSerializationContext(NbtOps.INSTANCE), (Object)compound).getOrThrow());
    }

    @NotNull
    public Map<String, Object> serializeStack(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return Map.of("id", "minecraft:air", "DataVersion", this.getDataVersion(), "schema_version", 1);
        }
        CompoundTag tag = (CompoundTag)net.minecraft.world.item.ItemStack.CODEC.encodeStart(CraftRegistry.getMinecraftRegistry().createSerializationContext(NbtOps.INSTANCE), (Object)CraftItemStack.asNMSCopy(itemStack)).getOrThrow();
        NbtUtils.addCurrentDataVersion(tag);
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        tag.asCompound().get().forEach((key, value) -> {
            switch (key) {
                case "id": {
                    ret.put("id", value.asString().get());
                    break;
                }
                case "count": {
                    ret.put("count", value.asInt().get());
                    break;
                }
                case "components": {
                    LinkedHashMap components = new LinkedHashMap();
                    value.asCompound().ifPresent(compoundTag -> compoundTag.forEach((componentKey, componentTag) -> {
                        String serializedComponent = componentTag.toString();
                        components.put(componentKey, serializedComponent);
                    }));
                    ret.put("components", components);
                    break;
                }
                case "DataVersion": {
                    ret.put("DataVersion", value.asInt().get());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        });
        ret.put("schema_version", 1);
        return ret;
    }

    @NotNull
    public ItemStack deserializeStack(@NotNull Map<String, Object> args) {
        int n;
        Object object = args.getOrDefault("schema_version", 1);
        if (object instanceof Number) {
            Number val = (Number)object;
            n = val.intValue();
        } else {
            n = -1;
        }
        int version = n;
        CompoundTag tag = new CompoundTag();
        args.forEach((key, value) -> {
            switch (key) {
                case "id": {
                    tag.putString("id", (String)value);
                    break;
                }
                case "count": {
                    tag.putInt("count", ((Number)value).intValue());
                    break;
                }
                case "components": {
                    if (version == 1) {
                        HashMap<String, String> componentMap;
                        if (value instanceof Map) {
                            componentMap = (HashMap<String, String>)value;
                        } else if (value instanceof MemorySection) {
                            MemorySection memory = (MemorySection)value;
                            componentMap = new HashMap<String, String>();
                            for (String memoryKey : memory.getKeys(false)) {
                                componentMap.put(memoryKey, memory.getString(memoryKey));
                            }
                        } else {
                            throw new IllegalArgumentException("components must be a Map");
                        }
                        CompoundTag componentsTag = new CompoundTag();
                        componentMap.forEach((componentKey, componentString) -> {
                            Tag componentTag;
                            try {
                                componentTag = SNBT_REGISTRY_UNAWARE_PARSER.parseFully((String)componentString);
                            }
                            catch (CommandSyntaxException e) {
                                throw new RuntimeException("Error parsing item stack data components", e);
                            }
                            componentsTag.put((String)componentKey, componentTag);
                        });
                        tag.put("components", componentsTag);
                        break;
                    }
                    throw new IllegalStateException("Unexpected version: " + version);
                }
                case "DataVersion": {
                    tag.putInt("DataVersion", ((Number)value).intValue());
                    break;
                }
                case "==": 
                case "schema_version": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        });
        return this.deserializeItem(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject serializeItemAsJson(ItemStack itemStack) {
        JsonObject item;
        Preconditions.checkNotNull((Object)itemStack, (Object)"Cannot serialize empty ItemStack");
        Preconditions.checkArgument((!itemStack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot serialize empty ItemStack");
        RegistryAccess.Frozen reg = MinecraftServer.getServer().registryAccess();
        RegistryOps ops = reg.createSerializationContext(JsonOps.INSTANCE);
        CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(true);
        try {
            item = ((JsonElement)net.minecraft.world.item.ItemStack.CODEC.encodeStart(ops, (Object)CraftItemStack.unwrap(itemStack)).getOrThrow()).getAsJsonObject();
        }
        finally {
            CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(false);
        }
        item.addProperty("DataVersion", (Number)this.getDataVersion());
        return item;
    }

    public ItemStack deserializeItemFromJson(JsonObject data) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        int dataVersion = data.get("DataVersion").getAsInt();
        int currentVersion = INSTANCE.getDataVersion();
        data = (JsonObject)MinecraftServer.getServer().fixerUpper.update(References.ITEM_STACK, new Dynamic<JsonObject>((DynamicOps<JsonObject>)JsonOps.INSTANCE, data), dataVersion, currentVersion).getValue();
        RegistryOps ops = MinecraftServer.getServer().registryAccess().createSerializationContext(JsonOps.INSTANCE);
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse(ops, (Object)data).getOrThrow(IllegalArgumentException::new));
    }

    public byte[] serializeEntity(Entity entity, EntitySerializationFlag ... serializationFlags) {
        Preconditions.checkNotNull((Object)entity, (Object)"null cannot be serialized");
        Preconditions.checkArgument((boolean)(entity instanceof CraftEntity), (Object)"Only CraftEntities can be serialized");
        Set<EntitySerializationFlag> flags = Set.of(serializationFlags);
        boolean serializePassengers = flags.contains(EntitySerializationFlag.PASSENGERS);
        boolean forceSerialization = flags.contains(EntitySerializationFlag.FORCE);
        boolean allowPlayerSerialization = flags.contains(EntitySerializationFlag.PLAYER);
        boolean allowMiscSerialization = flags.contains(EntitySerializationFlag.MISC);
        boolean includeNonSaveable = allowPlayerSerialization || allowMiscSerialization;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        (serializePassengers ? nmsEntity.getSelfAndPassengers() : Stream.of(nmsEntity)).forEach(e -> {
            Preconditions.checkArgument((e.getBukkitEntity().isValid() && e.getBukkitEntity().isPersistent() || forceSerialization ? 1 : 0) != 0, (String)"Cannot serialize invalid or non-persistent entity %s(%s) without the FORCE flag", (Object)e.getType().toShortString(), (Object)e.getStringUUID());
            if (e instanceof Player) {
                Preconditions.checkArgument((boolean)allowPlayerSerialization, (String)"Cannot serialize player(%s) without the PLAYER flag", (Object)e.getStringUUID());
            } else {
                Preconditions.checkArgument((nmsEntity.getType().canSerialize() || allowMiscSerialization ? 1 : 0) != 0, (String)"Cannot serialize misc non-saveable entity %s(%s) without the MISC flag", (Object)e.getType().toShortString(), (Object)e.getStringUUID());
            }
        });
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "serialiseEntity@" + String.valueOf(entity.getUniqueId()), LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext(problemReporter, nmsEntity.registryAccess());
            if (serializePassengers) {
                if (!nmsEntity.saveAsPassenger(output, true, includeNonSaveable, forceSerialization)) {
                    throw new IllegalArgumentException("Couldn't serialize entity");
                }
            } else {
                ArrayList<net.minecraft.world.entity.Entity> pass = new ArrayList<net.minecraft.world.entity.Entity>(nmsEntity.getPassengers());
                nmsEntity.passengers = ImmutableList.of();
                boolean serialized = nmsEntity.saveAsPassenger(output, true, includeNonSaveable, forceSerialization);
                nmsEntity.passengers = ImmutableList.copyOf(pass);
                if (!serialized) {
                    throw new IllegalArgumentException("Couldn't serialize entity");
                }
            }
            byte[] byArray = this.serializeNbtToBytes(output.buildResult());
            return byArray;
        }
    }

    public Entity deserializeEntity(byte[] data, World world, boolean preserveUUID, boolean preservePassengers) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"Cannot deserialize empty data");
        CompoundTag compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.getIntOr("DataVersion", 0);
        compound = PlatformHooks.get().convertNBT(References.ENTITY, MinecraftServer.getServer().fixerUpper, compound, dataVersion, this.getDataVersion());
        if (!preservePassengers) {
            compound.remove("Passengers");
        }
        net.minecraft.world.entity.Entity nmsEntity = this.deserializeEntity(compound, ((CraftWorld)world).getHandle(), preserveUUID);
        return nmsEntity.getBukkitEntity();
    }

    private net.minecraft.world.entity.Entity deserializeEntity(CompoundTag compound, ServerLevel world, boolean preserveUUID) {
        net.minecraft.world.entity.Entity nmsEntity;
        if (!preserveUUID) {
            compound.remove("UUID");
        }
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "deserialiseEntity", LOGGER);){
            nmsEntity = EntityType.create(TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)world.registryAccess(), compound), world, EntitySpawnReason.LOAD).orElseThrow(() -> new IllegalArgumentException("An ID was not found for the data. Did you downgrade?"));
        }
        compound.getList("Passengers").ifPresent(passengers -> {
            for (Tag tag : passengers) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag serializedPassenger = (CompoundTag)tag;
                net.minecraft.world.entity.Entity passengerEntity = this.deserializeEntity(serializedPassenger, world, preserveUUID);
                passengerEntity.startRiding(nmsEntity, true, true);
            }
        });
        return nmsEntity;
    }

    private byte[] serializeNbtToBytes(CompoundTag compound) {
        compound.putInt("DataVersion", this.getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NbtIo.writeCompressed(compound, outputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }

    private CompoundTag deserializeNbtFromBytes(byte[] data) {
        CompoundTag compound;
        try {
            compound = NbtIo.readCompressed(new ByteArrayInputStream(data), NbtAccounter.unlimitedHeap());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int dataVersion = compound.getIntOr("DataVersion", 0);
        Preconditions.checkArgument((dataVersion <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        return compound;
    }

    public int nextEntityId() {
        return net.minecraft.world.entity.Entity.nextEntityId();
    }

    public String getMainLevelName() {
        return ((DedicatedServer)MinecraftServer.getServer()).getProperties().levelName;
    }

    public int getProtocolVersion() {
        return SharedConstants.getCurrentVersion().protocolVersion();
    }

    public boolean isValidRepairItemStack(ItemStack itemToBeRepaired, ItemStack repairMaterial) {
        if (!itemToBeRepaired.getType().isItem() || !repairMaterial.getType().isItem()) {
            return false;
        }
        return CraftItemStack.unwrap(itemToBeRepaired).isValidRepairItem(CraftItemStack.unwrap(repairMaterial));
    }

    public boolean hasDefaultEntityAttributes(NamespacedKey entityKey) {
        return DefaultAttributes.hasSupplier(BuiltInRegistries.ENTITY_TYPE.getValue(CraftNamespacedKey.toMinecraft(entityKey)));
    }

    public Attributable getDefaultEntityAttributes(NamespacedKey entityKey) {
        Preconditions.checkArgument((boolean)this.hasDefaultEntityAttributes(entityKey), (Object)(String.valueOf(entityKey) + " doesn't have default attributes"));
        AttributeSupplier supplier = DefaultAttributes.getSupplier(BuiltInRegistries.ENTITY_TYPE.getValue(CraftNamespacedKey.toMinecraft(entityKey)));
        return new UnmodifiableAttributeMap(supplier);
    }

    public NamespacedKey getBiomeKey(RegionAccessor accessor, int x, int y, int z) {
        return accessor.getBiome(x, y, z).getKey();
    }

    public void setBiomeKey(RegionAccessor accessor, int x, int y, int z, NamespacedKey biomeKey) {
        accessor.setBiome(x, y, z, (Biome)Registry.BIOME.getOrThrow(biomeKey));
    }

    public String getStatisticCriteriaKey(Statistic statistic) {
        if (statistic.getType() != Statistic.Type.UNTYPED) {
            return "minecraft.custom:minecraft." + statistic.getKey().getKey();
        }
        return CraftStatistic.getNMSStatistic(statistic).getName();
    }

    public List<Component> computeTooltipLines(ItemStack itemStack, TooltipContext tooltipContext, org.bukkit.entity.Player player) {
        TooltipFlag.Default flag;
        Preconditions.checkArgument((tooltipContext != null ? 1 : 0) != 0, (Object)"tooltipContext cannot be null");
        TooltipFlag.Default default_ = flag = tooltipContext.isAdvanced() ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        if (tooltipContext.isCreative()) {
            flag = flag.asCreative();
        }
        List<net.minecraft.network.chat.Component> lines = CraftItemStack.asNMSCopy(itemStack).getTooltipLines(Item.TooltipContext.of(player == null ? CraftRegistry.getMinecraftRegistry() : ((CraftPlayer)player).getHandle().level().registryAccess()), player == null ? null : ((CraftPlayer)player).getHandle(), flag);
        return lines.stream().map(PaperAdventure::asAdventure).toList();
    }

    public Color getSpawnEggLayerColor(org.bukkit.entity.EntityType entityType, int layer) {
        EntityType<?> nmsType = CraftEntityType.bukkitToMinecraft(entityType);
        SpawnEggItem eggItem = SpawnEggItem.byId(nmsType);
        if (eggItem != null) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public LifecycleEventManager<Plugin> createPluginLifecycleEventManager(JavaPlugin plugin, BooleanSupplier registrationCheck) {
        return new PaperLifecycleEventManager<JavaPlugin>(plugin, registrationCheck);
    }

    public ItemStack createEmptyStack() {
        return CraftItemStack.asCraftMirror(null);
    }

    static {
        for (Block block2 : BuiltInRegistries.BLOCK) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial((String)BuiltInRegistries.BLOCK.getKey(block2).getPath().toUpperCase(Locale.ROOT)));
        }
        for (Item item2 : BuiltInRegistries.ITEM) {
            ITEM_MATERIAL.put(item2, Material.getMaterial((String)BuiltInRegistries.ITEM.getKey(item2).getPath().toUpperCase(Locale.ROOT)));
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            ResourceLocation key = CraftNamespacedKey.toMinecraft(material.getKey());
            BuiltInRegistries.ITEM.getOptional(key).ifPresent(item -> MATERIAL_ITEM.put(material, (Item)item));
            BuiltInRegistries.BLOCK.getOptional(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (Block)block));
        }
        SNBT_REGISTRY_UNAWARE_PARSER = TagParser.create(NbtOps.INSTANCE);
    }
}

