/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.util.LazyHashSet;
import org.bukkit.entity.Player;

public class LazyPlayerSet
extends LazyHashSet<Player> {
    private final MinecraftServer server;

    public LazyPlayerSet(MinecraftServer server) {
        this.server = server;
    }

    @Override
    protected Set<Player> makeReference() {
        Preconditions.checkState((this.reference == null ? 1 : 0) != 0, (Object)"Reference already created!");
        return LazyPlayerSet.makePlayerSet(this.server);
    }

    public static Set<Player> makePlayerSet(MinecraftServer server) {
        List<ServerPlayer> players = server.getPlayerList().players;
        HashSet<Player> reference = new HashSet<Player>(players.size());
        for (ServerPlayer player : players) {
            reference.add(player.getBukkitEntity());
        }
        return reference;
    }
}

