/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConnectionRequestBuilder;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.crypto.KeyIdentifiable;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSink;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.messages.PluginMessageEncoder;
import com.velocitypowered.api.proxy.player.PlayerSettings;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.api.util.ServerLink;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public interface Player
extends CommandSource,
InboundConnection,
ChannelMessageSource,
ChannelMessageSink,
Identified,
HoverEventSource<HoverEvent.ShowEntity>,
Keyed,
KeyIdentifiable,
Sound.Emitter {
    public String getUsername();

    public @Nullable Locale getEffectiveLocale();

    public void setEffectiveLocale(Locale var1);

    public UUID getUniqueId();

    public Optional<ServerConnection> getCurrentServer();

    public PlayerSettings getPlayerSettings();

    public boolean hasSentPlayerSettings();

    public Optional<ModInfo> getModInfo();

    public long getPing();

    public boolean isOnlineMode();

    public ConnectionRequestBuilder createConnectionRequest(RegisteredServer var1);

    public List<GameProfile.Property> getGameProfileProperties();

    public void setGameProfileProperties(List<GameProfile.Property> var1);

    public GameProfile getGameProfile();

    @Deprecated
    default public void clearHeaderAndFooter() {
        this.clearPlayerListHeaderAndFooter();
    }

    public void clearPlayerListHeaderAndFooter();

    public Component getPlayerListHeader();

    public Component getPlayerListFooter();

    public TabList getTabList();

    public void disconnect(Component var1);

    public void spoofChatInput(String var1);

    @Deprecated
    public void sendResourcePack(String var1);

    @Deprecated
    public void sendResourcePack(String var1, byte[] var2);

    public void sendResourcePackOffer(ResourcePackInfo var1);

    @Deprecated
    public @Nullable ResourcePackInfo getAppliedResourcePack();

    @Deprecated
    public @Nullable ResourcePackInfo getPendingResourcePack();

    @NotNull
    public Collection<ResourcePackInfo> getAppliedResourcePacks();

    @NotNull
    public Collection<ResourcePackInfo> getPendingResourcePacks();

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier var1, byte @NotNull [] var2);

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier var1, @NotNull PluginMessageEncoder var2);

    @Override
    @NotNull
    default public Key key() {
        return Key.key("player");
    }

    @Override
    @NotNull
    default public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowEntity> op) {
        return HoverEvent.showEntity((HoverEvent.ShowEntity)op.apply(HoverEvent.ShowEntity.showEntity(this, this.getUniqueId(), (Component)Component.text(this.getUsername()))));
    }

    public @Nullable String getClientBrand();

    public void addCustomChatCompletions(@NotNull Collection<String> var1);

    public void removeCustomChatCompletions(@NotNull Collection<String> var1);

    public void setCustomChatCompletions(@NotNull Collection<String> var1);

    @Override
    default public void playSound(@NotNull Sound sound) {
    }

    @Override
    default public void playSound(@NotNull Sound sound, double x, double y, double z) {
    }

    @Override
    default public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
    }

    @Override
    default public void stopSound(@NotNull SoundStop stop) {
    }

    @Override
    default public void openBook(@NotNull Book book) {
    }

    @Override
    default public void showDialog(@NotNull DialogLike dialog) {
    }

    @Override
    default public void closeDialog() {
    }

    public void transferToHost(@NotNull InetSocketAddress var1);

    public void storeCookie(Key var1, byte[] var2);

    public void requestCookie(Key var1);

    public void setServerLinks(@NotNull List<ServerLink> var1);
}

