/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public final class ServerLink {
    @Nullable
    private Type type;
    @Nullable
    private Component label;
    private final URI url;

    private ServerLink(Component label, String url) {
        this.label = Preconditions.checkNotNull(label, "label");
        this.url = URI.create(url);
    }

    private ServerLink(Type type, String url) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.url = URI.create(url);
    }

    public static ServerLink serverLink(Component label, String link) {
        return new ServerLink(label, link);
    }

    public static ServerLink serverLink(Type type, String link) {
        return new ServerLink(type, link);
    }

    public Optional<Type> getBuiltInType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<Component> getCustomLabel() {
        return Optional.ofNullable(this.label);
    }

    public URI getUrl() {
        return this.url;
    }

    public static enum Type {
        BUG_REPORT,
        COMMUNITY_GUIDELINES,
        SUPPORT,
        STATUS,
        FEEDBACK,
        COMMUNITY,
        WEBSITE,
        FORUMS,
        NEWS,
        ANNOUNCEMENTS;

    }
}

