/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.spotify.futures.CompletableFutures;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.command.VelocityCommands;
import com.velocitypowered.proxy.command.brigadier.VelocityArgumentCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.lock.qual.GuardedBy;

final class SuggestionsProvider<S> {
    private static final Logger LOGGER = LogManager.getLogger(SuggestionsProvider.class);
    private static final StringRange ALIAS_SUGGESTION_RANGE = StringRange.at(0);
    private final @GuardedBy(value={"lock"}) CommandDispatcher<S> dispatcher;
    private final Lock lock;
    private boolean announceProxyCommands;

    SuggestionsProvider(CommandDispatcher<S> dispatcher, Lock lock) {
        this.dispatcher = Preconditions.checkNotNull(dispatcher, "dispatcher");
        this.lock = Preconditions.checkNotNull(lock, "lock");
        this.announceProxyCommands = true;
    }

    public CompletableFuture<Suggestions> provideSuggestions(String input, S source) {
        CommandContextBuilder<S> context = new CommandContextBuilder<S>(this.dispatcher, source, this.dispatcher.getRoot(), 0);
        return this.provideSuggestions(new StringReader(input), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Suggestions> provideSuggestions(StringReader reader, CommandContextBuilder<S> context) {
        this.lock.lock();
        try {
            StringRange aliasRange = this.consumeAlias(reader);
            String alias = aliasRange.get(reader).toLowerCase(Locale.ENGLISH);
            LiteralCommandNode literal = (LiteralCommandNode)context.getRootNode().getChild(alias);
            boolean hasArguments = reader.canRead();
            if (hasArguments) {
                if (literal == null) {
                    CompletableFuture<Suggestions> completableFuture = Suggestions.empty();
                    return completableFuture;
                }
                context.withNode(literal, aliasRange);
                reader.skip();
                CompletableFuture<Suggestions> completableFuture = this.provideArgumentsSuggestions(literal, reader, context);
                return completableFuture;
            }
            CompletableFuture<Suggestions> completableFuture = this.provideAliasSuggestions(reader, context);
            return completableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    private StringRange consumeAlias(StringReader reader) {
        int firstSep = reader.getString().indexOf(32, reader.getCursor());
        StringRange range = StringRange.between(reader.getCursor(), firstSep == -1 ? reader.getTotalLength() : firstSep);
        reader.setCursor(range.getEnd());
        return range;
    }

    private static boolean shouldConsider(String name, String input) {
        return name.regionMatches(false, 0, input, 0, input.length());
    }

    private CompletableFuture<Suggestions> provideAliasSuggestions(StringReader reader, CommandContextBuilder<S> contextSoFar) {
        S source = contextSoFar.getSource();
        String input = reader.getRead().toLowerCase(Locale.ENGLISH);
        if (source instanceof Player && !this.announceProxyCommands) {
            return new SuggestionsBuilder(input, 0).buildFuture();
        }
        Collection<CommandNode<S>> aliases = contextSoFar.getRootNode().getChildren();
        CompletableFuture[] futures = new CompletableFuture[aliases.size()];
        int i = 0;
        for (CommandNode<S> node : aliases) {
            CommandContextBuilder<S> context;
            CompletableFuture<Suggestions> future = Suggestions.empty();
            String alias = node.getName();
            if (SuggestionsProvider.shouldConsider(alias, input) && node.canUse(source) && node.canUse(context = contextSoFar.copy().withNode(node, ALIAS_SUGGESTION_RANGE), reader)) {
                SuggestionsBuilder builder = new SuggestionsBuilder(input, 0);
                future = builder.suggest(alias).buildFuture();
            }
            futures[i++] = future;
        }
        return this.merge(input, futures);
    }

    private CompletableFuture<Suggestions> provideArgumentsSuggestions(LiteralCommandNode<S> alias, StringReader reader, CommandContextBuilder<S> contextSoFar) {
        boolean hasHints;
        S source = contextSoFar.getSource();
        String fullInput = reader.getString();
        VelocityArgumentCommandNode<S, ?> argsNode = VelocityCommands.getArgumentsNode(alias);
        if (argsNode == null) {
            reader.setCursor(0);
            ParseResults<S> parse = this.dispatcher.parse(reader, source);
            try {
                return this.dispatcher.getCompletionSuggestions(parse);
            }
            catch (Throwable e) {
                LOGGER.error("Command node cannot provide suggestions for " + fullInput, e);
                return Suggestions.empty();
            }
        }
        if (!argsNode.canUse(source)) {
            return Suggestions.empty();
        }
        int start = reader.getCursor();
        CommandContextBuilder<S> context = contextSoFar.copy();
        try {
            argsNode.parse(reader, context);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!argsNode.canUse(context, reader)) {
            return Suggestions.empty();
        }
        reader.setCursor(start);
        CompletableFuture<Suggestions> cmdSuggestions = this.getArgumentsNodeSuggestions(argsNode, reader, context);
        boolean bl = hasHints = alias.getChildren().size() > 1;
        if (!hasHints) {
            return this.merge(fullInput, cmdSuggestions);
        }
        reader.setCursor(start);
        CompletableFuture<Suggestions> hintSuggestions = this.getHintSuggestions(alias, reader, contextSoFar);
        return this.merge(fullInput, cmdSuggestions, hintSuggestions);
    }

    private CompletableFuture<Suggestions> getArgumentsNodeSuggestions(VelocityArgumentCommandNode<S, ?> node, StringReader reader, CommandContextBuilder<S> context) {
        int start = reader.getCursor();
        String fullInput = reader.getString();
        CommandContext<S> built = context.build(fullInput);
        try {
            return node.listSuggestions(built, new SuggestionsBuilder(fullInput, start));
        }
        catch (Throwable e) {
            LOGGER.error("Arguments node cannot provide suggestions", e);
            return Suggestions.empty();
        }
    }

    private CompletableFuture<Suggestions> getHintSuggestions(LiteralCommandNode<S> alias, StringReader reader, CommandContextBuilder<S> context) {
        ParseResults<S> parse = this.parseHints(alias, reader, context);
        try {
            return this.dispatcher.getCompletionSuggestions(parse);
        }
        catch (Throwable e) {
            LOGGER.error("Hint node cannot provide suggestions", e);
            return Suggestions.empty();
        }
    }

    private ParseResults<S> parseHints(CommandNode<S> node, StringReader originalReader, CommandContextBuilder<S> contextSoFar) {
        ArrayList<ParseResults<S>> potentials = null;
        for (CommandNode<S> child : node.getRelevantNodes(originalReader)) {
            if (VelocityCommands.isArgumentsNode(child)) continue;
            CommandContextBuilder<S> context = contextSoFar.copy();
            StringReader reader = new StringReader(originalReader);
            try {
                child.parse(reader, context);
                if (reader.canRead() && reader.peek() != ' ') {
                }
            }
            catch (CommandSyntaxException e) {}
            continue;
            if (!reader.canRead(2)) continue;
            reader.skip();
            ParseResults<S> parse = this.parseHints(child, reader, context);
            if (potentials == null) {
                potentials = new ArrayList<ParseResults<S>>(1);
            }
            potentials.add(parse);
        }
        if (potentials != null) {
            if (potentials.size() > 1) {
                potentials.sort((a, b) -> {
                    if (!a.getReader().canRead() && b.getReader().canRead()) {
                        return -1;
                    }
                    if (a.getReader().canRead() && !b.getReader().canRead()) {
                        return 1;
                    }
                    return 0;
                });
            }
            return (ParseResults)potentials.get(0);
        }
        return new ParseResults<S>(contextSoFar, originalReader, Collections.emptyMap());
    }

    @SafeVarargs
    private CompletableFuture<Suggestions> merge(String fullInput, CompletableFuture<Suggestions> ... futures) {
        return CompletableFuture.allOf(futures).handle((unused, throwable) -> {
            ArrayList<Suggestions> suggestions = new ArrayList<Suggestions>(futures.length);
            for (CompletableFuture future : futures) {
                if (future.isCompletedExceptionally()) {
                    Throwable exception = CompletableFutures.getException(future);
                    LOGGER.error("Node cannot provide suggestions", exception);
                    continue;
                }
                suggestions.add((Suggestions)future.join());
            }
            return Suggestions.merge(fullInput, suggestions);
        });
    }

    public void setAnnounceProxyCommands(boolean announceProxyCommands) {
        this.announceProxyCommands = announceProxyCommands;
    }
}

