/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class MinecraftEncoder
extends MessageToByteEncoder<MinecraftPacket> {
    private final ProtocolUtils.Direction direction;
    private StateRegistry state;
    private StateRegistry.PacketRegistry.ProtocolRegistry registry;

    public MinecraftEncoder(ProtocolUtils.Direction direction) {
        this.direction = Preconditions.checkNotNull(direction, "direction");
        this.registry = StateRegistry.HANDSHAKE.getProtocolRegistry(direction, ProtocolVersion.MINIMUM_VERSION);
        this.state = StateRegistry.HANDSHAKE;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, MinecraftPacket msg, ByteBuf out) {
        int packetId = this.registry.getPacketId(msg);
        ProtocolUtils.writeVarInt(out, packetId);
        msg.encode(out, this.direction, this.registry.version);
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, MinecraftPacket msg, boolean preferDirect) throws Exception {
        int hint = msg.encodeSizeHint(this.direction, this.registry.version);
        if (hint < 0) {
            return super.allocateBuffer(ctx, msg, preferDirect);
        }
        int packetId = this.registry.getPacketId(msg);
        int totalHint = ProtocolUtils.varIntBytes(packetId) + hint;
        return preferDirect ? ctx.alloc().ioBuffer(totalHint) : ctx.alloc().heapBuffer(totalHint);
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.registry = this.state.getProtocolRegistry(this.direction, protocolVersion);
    }

    public void setState(StateRegistry state) {
        this.state = state;
        this.setProtocolVersion(this.registry.version);
    }

    public ProtocolUtils.Direction getDirection() {
        return this.direction;
    }
}

