/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;

public class KeepAlivePacket
implements MinecraftPacket {
    private long randomId;

    public long getRandomId() {
        return this.randomId;
    }

    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    public String toString() {
        return "KeepAlive{randomId=" + this.randomId + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.randomId = version.noLessThan(ProtocolVersion.MINECRAFT_1_12_2) ? buf.readLong() : (version.noLessThan(ProtocolVersion.MINECRAFT_1_8) ? (long)ProtocolUtils.readVarInt(buf) : (long)buf.readInt());
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_12_2)) {
            buf.writeLong(this.randomId);
        } else if (version.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            ProtocolUtils.writeVarInt(buf, (int)this.randomId);
        } else {
            buf.writeInt((int)this.randomId);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

