/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerLoginPacket
implements MinecraftPacket {
    private static final QuietDecoderException EMPTY_USERNAME = new QuietDecoderException("Empty username!");
    private @Nullable String username;
    private @Nullable IdentifiedKey playerKey;
    private @Nullable UUID holderUuid;

    public ServerLoginPacket() {
    }

    public ServerLoginPacket(String username, @Nullable IdentifiedKey playerKey) {
        this.username = Preconditions.checkNotNull(username, "username");
        this.playerKey = playerKey;
    }

    public ServerLoginPacket(String username, @Nullable UUID holderUuid) {
        this.username = Preconditions.checkNotNull(username, "username");
        this.holderUuid = holderUuid;
        this.playerKey = null;
    }

    public String getUsername() {
        if (this.username == null) {
            throw new IllegalStateException("No username found!");
        }
        return this.username;
    }

    public @Nullable IdentifiedKey getPlayerKey() {
        return this.playerKey;
    }

    public void setPlayerKey(IdentifiedKey playerKey) {
        this.playerKey = playerKey;
    }

    public @Nullable UUID getHolderUuid() {
        return this.holderUuid;
    }

    public String toString() {
        return "ServerLogin{username='" + this.username + "'playerKey='" + String.valueOf(this.playerKey) + "'holderUUID='" + String.valueOf(this.holderUuid) + "'}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.username = ProtocolUtils.readString(buf, 16);
        if (this.username.isEmpty()) {
            throw EMPTY_USERNAME;
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            this.playerKey = version.noLessThan(ProtocolVersion.MINECRAFT_1_19_3) ? null : (buf.readBoolean() ? ProtocolUtils.readPlayerKey(version, buf) : null);
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                this.holderUuid = ProtocolUtils.readUuid(buf);
                return;
            }
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19_1) && buf.readBoolean()) {
                this.holderUuid = ProtocolUtils.readUuid(buf);
            }
        } else {
            this.playerKey = null;
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.username == null) {
            throw new IllegalStateException("No username found!");
        }
        ProtocolUtils.writeString(buf, this.username);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            if (version.lessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
                if (this.playerKey != null) {
                    buf.writeBoolean(true);
                    ProtocolUtils.writePlayerKey(buf, this.playerKey);
                } else {
                    buf.writeBoolean(false);
                }
            }
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                ProtocolUtils.writeUuid(buf, this.holderUuid);
                return;
            }
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19_1)) {
                if (this.playerKey != null && this.playerKey.getSignatureHolder() != null) {
                    buf.writeBoolean(true);
                    ProtocolUtils.writeUuid(buf, this.playerKey.getSignatureHolder());
                } else if (this.holderUuid != null) {
                    buf.writeBoolean(true);
                    ProtocolUtils.writeUuid(buf, this.holderUuid);
                } else {
                    buf.writeBoolean(false);
                }
            }
        }
    }

    @Override
    public int decodeExpectedMaxLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        int base = 49;
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            if (version.lessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
                base += 819;
            }
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19_1)) {
                base += 17;
            }
        }
        return base;
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

