/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.keyed;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatType;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.chat.SystemChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderV2;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerCommandPacket;
import net.kyori.adventure.text.Component;

public class KeyedChatBuilder
extends ChatBuilderV2 {
    public KeyedChatBuilder(ProtocolVersion version) {
        super(version);
    }

    @Override
    public MinecraftPacket toClient() {
        Component msg = this.component == null ? Component.text(this.message) : this.component;
        return new SystemChatPacket(new ComponentHolder(this.version, msg), this.type == ChatType.CHAT ? ChatType.SYSTEM : this.type);
    }

    @Override
    public MinecraftPacket toServer() {
        if (this.message.startsWith("/")) {
            return new KeyedPlayerCommandPacket(this.message.substring(1), ImmutableList.of(), this.timestamp);
        }
        KeyedPlayerChatPacket v1Chat = new KeyedPlayerChatPacket(this.message);
        v1Chat.setExpiry(this.timestamp);
        return v1Chat;
    }
}

