/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util.ratelimit;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.velocitypowered.proxy.util.ratelimit.Ratelimiter;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CaffeineCacheRatelimiter<T>
implements Ratelimiter<T> {
    private final Cache<T, Long> expiringCache;
    private final long timeoutNanos;

    CaffeineCacheRatelimiter(long time, TimeUnit unit) {
        this(time, unit, Ticker.systemTicker());
    }

    @VisibleForTesting
    CaffeineCacheRatelimiter(long time, TimeUnit unit, Ticker ticker) {
        Preconditions.checkNotNull(unit, "unit");
        Preconditions.checkNotNull(ticker, "ticker");
        this.timeoutNanos = unit.toNanos(time);
        this.expiringCache = Caffeine.newBuilder().ticker(ticker).expireAfterWrite(time, unit).build();
    }

    @Override
    public boolean attempt(@NotNull T key) {
        long last;
        long expectedNewValue = System.nanoTime() + this.timeoutNanos;
        return expectedNewValue == (last = this.expiringCache.get(key, key1 -> expectedNewValue).longValue());
    }
}

