/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.reference;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.reactive.Processor;
import ninja.leaping.configurate.reactive.Publisher;
import ninja.leaping.configurate.reference.ConfigurationReference;
import ninja.leaping.configurate.reference.ValueReference;
import ninja.leaping.configurate.reference.ValueReferenceImpl;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ManualConfigurationReference<N extends ConfigurationNode>
implements ConfigurationReference<N> {
    protected volatile @MonotonicNonNull N node;
    private final ConfigurationLoader<? extends N> loader;
    protected final Processor.TransactionalIso<N> updateListener;
    protected final Processor.Iso<Map.Entry<ConfigurationReference.ErrorPhase, Throwable>> errorListener;

    ManualConfigurationReference(ConfigurationLoader<? extends N> loader, Executor taskExecutor) {
        this.loader = loader;
        this.updateListener = Processor.createTransactional(taskExecutor);
        this.errorListener = Processor.create(taskExecutor);
        this.errorListener.setFallbackHandler(it -> {
            System.out.println("Unhandled error while performing a " + it.getKey() + " for a configuration reference: " + it.getValue());
            ((Throwable)it.getValue()).printStackTrace();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        ConfigurationLoader<? extends N> configurationLoader = this.loader;
        synchronized (configurationLoader) {
            this.node = this.loader.load();
            this.updateListener.submit(this.node);
        }
    }

    @Override
    public void save() throws IOException {
        this.save(this.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(N newNode) throws IOException {
        ConfigurationLoader<? extends N> configurationLoader = this.loader;
        synchronized (configurationLoader) {
            this.node = (ConfigurationNode)Objects.requireNonNull(newNode);
            this.loader.save((ConfigurationNode)this.node);
        }
    }

    @Override
    public Publisher<N> saveAsync() {
        return Publisher.execute(() -> {
            this.save();
            return this.getNode();
        }, this.updateListener.getExecutor());
    }

    @Override
    public Publisher<N> updateAsync(Function<N, ? extends N> updater) {
        return Publisher.execute(() -> {
            ConfigurationNode newNode = (ConfigurationNode)updater.apply(this.getNode());
            this.save(newNode);
            return newNode;
        }, this.updateListener.getExecutor());
    }

    @Override
    public N getNode() {
        return this.node;
    }

    @Override
    public ConfigurationLoader<? extends N> getLoader() {
        return this.loader;
    }

    @Override
    public N get(Object ... path) {
        return (N)this.getNode().getNode(path);
    }

    @Override
    public <T> ValueReference<T> referenceTo(TypeToken<T> type, Object[] path, @Nullable T def) throws ObjectMappingException {
        return new ValueReferenceImpl<T>(this, path, type, def);
    }

    @Override
    public <T> ValueReference<T> referenceTo(Class<T> type, Object[] path, @Nullable T def) throws ObjectMappingException {
        return new ValueReferenceImpl<T>(this, path, type, def);
    }

    @Override
    public Publisher<N> updates() {
        return this.updateListener;
    }

    @Override
    public Publisher<Map.Entry<ConfigurationReference.ErrorPhase, Throwable>> errors() {
        return this.errorListener;
    }

    @Override
    public void close() {
        this.updateListener.onClose();
    }
}

