/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.completable;

import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Completable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Completable.class);
    private static final Function<? super Throwable, ? extends Throwable> DEFAULT_EXCEPTION_HANDLER = thr -> {
        LOGGER.error("Unhandled exception during Completable operation", thr);
        return thr;
    };
    private static final Transform<?, ?> COMPLETED_STACK = new Transform<Object, Object>(null, null, null, null){

        @Override
        public void run() {
        }
    };
    private volatile Transform<?, T> completeStack;
    private static final VarHandle COMPLETE_STACK_HANDLE = ConcurrentUtil.getVarHandle(Completable.class, "completeStack", Transform.class);
    private static final Object NULL_MASK = new Object();
    private volatile Object result;
    private static final VarHandle RESULT_HANDLE = ConcurrentUtil.getVarHandle(Completable.class, "result", Object.class);

    public static Executor getDefaultExecutor() {
        return ForkJoinPool.commonPool();
    }

    private Object getResultPlain() {
        return RESULT_HANDLE.get(this);
    }

    private Object getResultVolatile() {
        return RESULT_HANDLE.getVolatile(this);
    }

    private void pushStackOrRun(Transform<?, T> push) {
        int failures = 0;
        Transform curr = COMPLETE_STACK_HANDLE.getVolatile(this);
        while (true) {
            if (curr == COMPLETED_STACK) {
                push.execute();
                return;
            }
            push.next = curr;
            for (int i = 0; i < failures; ++i) {
                ConcurrentUtil.backoff();
            }
            if (curr == (curr = COMPLETE_STACK_HANDLE.compareAndExchange(this, curr, push))) {
                return;
            }
            push.next = null;
            ++failures;
        }
    }

    private void propagateStack() {
        Transform topStack = COMPLETE_STACK_HANDLE.getAndSet(this, COMPLETED_STACK);
        while (topStack != null) {
            topStack.execute();
            topStack = topStack.next;
        }
    }

    private static Object maskNull(Object res) {
        return res == null ? NULL_MASK : res;
    }

    private static Object unmaskNull(Object res) {
        return res == NULL_MASK ? null : res;
    }

    private static Executor checkExecutor(Executor executor) {
        return Objects.requireNonNull(executor, "Executor may not be null");
    }

    public Completable() {
    }

    private Completable(Object complete) {
        COMPLETE_STACK_HANDLE.set(this, COMPLETED_STACK);
        RESULT_HANDLE.setRelease(this, complete);
    }

    public static <T> Completable<T> completed(T value) {
        return new Completable<T>(Completable.maskNull(value));
    }

    public static <T> Completable<T> failed(Throwable ex) {
        Objects.requireNonNull(ex, "Exception may not be null");
        return new Completable<T>(new ExceptionResult(ex));
    }

    public static <T> Completable<T> supplied(Supplier<T> supplier) {
        return Completable.supplied(supplier, DEFAULT_EXCEPTION_HANDLER);
    }

    public static <T> Completable<T> supplied(Supplier<T> supplier, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        try {
            return Completable.completed(supplier.get());
        }
        catch (Throwable throwable) {
            Throwable complete;
            try {
                complete = exceptionHandler.apply(throwable);
            }
            catch (Throwable thr2) {
                throwable.addSuppressed(thr2);
                complete = throwable;
            }
            return Completable.failed(complete);
        }
    }

    public static <T> Completable<T> suppliedAsync(Supplier<T> supplier, Executor executor) {
        return Completable.suppliedAsync(supplier, executor, DEFAULT_EXCEPTION_HANDLER);
    }

    public static <T> Completable<T> suppliedAsync(final Supplier<T> supplier, Executor executor, final Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Completable<T> ret = new Completable<T>();
        try {
            class AsyncSuppliedCompletable
            implements Runnable,
            CompletableFuture.AsynchronousCompletionTask {
                AsyncSuppliedCompletable() {
                }

                @Override
                public void run() {
                    try {
                        Completable.this.complete(supplier.get());
                    }
                    catch (Throwable throwable) {
                        Throwable complete;
                        try {
                            complete = (Throwable)exceptionHandler.apply(throwable);
                        }
                        catch (Throwable thr2) {
                            throwable.addSuppressed(thr2);
                            complete = throwable;
                        }
                        Completable.this.completeExceptionally(complete);
                    }
                }
            }
            executor.execute(ret.new AsyncSuppliedCompletable());
        }
        catch (Throwable throwable) {
            Throwable complete;
            try {
                complete = exceptionHandler.apply(throwable);
            }
            catch (Throwable thr2) {
                throwable.addSuppressed(thr2);
                complete = throwable;
            }
            ret.completeExceptionally(complete);
        }
        return ret;
    }

    private boolean completeRaw(Object value) {
        if (RESULT_HANDLE.getVolatile(this) != null || !RESULT_HANDLE.compareAndSet(this, null, value)) {
            return false;
        }
        this.propagateStack();
        return true;
    }

    public boolean complete(T result) {
        return this.completeRaw(Completable.maskNull(result));
    }

    public boolean completeExceptionally(Throwable exception) {
        Objects.requireNonNull(exception, "Exception may not be null");
        return this.completeRaw(new ExceptionResult(exception));
    }

    public boolean isDone() {
        return this.getResultVolatile() != null;
    }

    public boolean isNormallyComplete() {
        return this.getResultVolatile() != null && !(this.getResultVolatile() instanceof ExceptionResult);
    }

    public boolean isExceptionallyComplete() {
        return this.getResultVolatile() instanceof ExceptionResult;
    }

    public Throwable getException() {
        Object res = this.getResultVolatile();
        if (res == null) {
            return null;
        }
        if (!(res instanceof ExceptionResult)) {
            throw new IllegalStateException("Not completed exceptionally");
        }
        ExceptionResult exRes = (ExceptionResult)res;
        return exRes.ex;
    }

    public T getNow(T dfl) throws CompletionException {
        Object res = this.getResultVolatile();
        if (res == null) {
            return dfl;
        }
        if (res instanceof ExceptionResult) {
            ExceptionResult exRes = (ExceptionResult)res;
            throw new CompletionException(exRes.ex);
        }
        return (T)Completable.unmaskNull(res);
    }

    public T join() throws CompletionException {
        if (this.isDone()) {
            return this.getNow(null);
        }
        UnparkTransform unparkTransform = new UnparkTransform(this, Thread.currentThread());
        this.pushStackOrRun(unparkTransform);
        boolean interuptted = false;
        while (!unparkTransform.isReleasable()) {
            try {
                ForkJoinPool.managedBlock(unparkTransform);
            }
            catch (InterruptedException ex) {
                interuptted = true;
            }
        }
        if (interuptted) {
            Thread.currentThread().interrupt();
        }
        return this.getNow(null);
    }

    public CompletableFuture<T> toFuture() {
        Object rawResult = this.getResultVolatile();
        if (rawResult != null) {
            if (rawResult instanceof ExceptionResult) {
                ExceptionResult exRes = (ExceptionResult)rawResult;
                return CompletableFuture.failedFuture(exRes.ex);
            }
            return CompletableFuture.completedFuture(Completable.unmaskNull(rawResult));
        }
        final CompletableFuture ret = new CompletableFuture();
        class ToFuture
        implements BiConsumer<T, Throwable> {
            ToFuture() {
            }

            @Override
            public void accept(T res, Throwable ex) {
                if (ex != null) {
                    ret.completeExceptionally(ex);
                } else {
                    ret.complete(res);
                }
            }
        }
        this.whenComplete(new ToFuture());
        return ret;
    }

    public static <T> Completable<T> fromFuture(CompletionStage<T> stage) {
        Completable<T> ret = new Completable<T>();
        class FromFuture
        implements BiConsumer<T, Throwable> {
            FromFuture() {
            }

            @Override
            public void accept(T res, Throwable ex) {
                if (ex != null) {
                    Completable.this.completeExceptionally(ex);
                } else {
                    Completable.this.complete(res);
                }
            }
        }
        stage.whenComplete(ret.new FromFuture());
        return ret;
    }

    public <U> Completable<U> thenApply(Function<? super T, ? extends U> function) {
        return this.thenApply(function, DEFAULT_EXCEPTION_HANDLER);
    }

    public <U> Completable<U> thenApply(Function<? super T, ? extends U> function, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(function, "Function may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new ApplyTransform<U, T>(null, this, ret, exceptionHandler, function));
        return ret;
    }

    public <U> Completable<U> thenApplyAsync(Function<? super T, ? extends U> function) {
        return this.thenApplyAsync(function, Completable.getDefaultExecutor(), DEFAULT_EXCEPTION_HANDLER);
    }

    public <U> Completable<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor) {
        return this.thenApplyAsync(function, executor, DEFAULT_EXCEPTION_HANDLER);
    }

    public <U> Completable<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(function, "Function may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new ApplyTransform<U, T>(Completable.checkExecutor(executor), this, ret, exceptionHandler, function));
        return ret;
    }

    public Completable<Void> thenAccept(Consumer<? super T> consumer) {
        return this.thenAccept(consumer, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<Void> thenAccept(Consumer<? super T> consumer, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(consumer, "Consumer may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<Void> ret = new Completable<Void>();
        this.pushStackOrRun(new AcceptTransform<T>(null, this, ret, exceptionHandler, consumer));
        return ret;
    }

    public Completable<Void> thenAcceptAsync(Consumer<? super T> consumer) {
        return this.thenAcceptAsync(consumer, Completable.getDefaultExecutor(), DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<Void> thenAcceptAsync(Consumer<? super T> consumer, Executor executor) {
        return this.thenAcceptAsync(consumer, executor, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<Void> thenAcceptAsync(Consumer<? super T> consumer, Executor executor, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(consumer, "Consumer may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<Void> ret = new Completable<Void>();
        this.pushStackOrRun(new AcceptTransform<T>(Completable.checkExecutor(executor), this, ret, exceptionHandler, consumer));
        return ret;
    }

    public Completable<Void> thenRun(Runnable run) {
        return this.thenRun(run, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<Void> thenRun(Runnable run, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(run, "Run may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<Void> ret = new Completable<Void>();
        this.pushStackOrRun(new RunTransform(null, this, ret, exceptionHandler, run));
        return ret;
    }

    public Completable<Void> thenRunAsync(Runnable run) {
        return this.thenRunAsync(run, Completable.getDefaultExecutor(), DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<Void> thenRunAsync(Runnable run, Executor executor) {
        return this.thenRunAsync(run, executor, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<Void> thenRunAsync(Runnable run, Executor executor, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(run, "Run may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<Void> ret = new Completable<Void>();
        this.pushStackOrRun(new RunTransform(Completable.checkExecutor(executor), this, ret, exceptionHandler, run));
        return ret;
    }

    public <U> Completable<U> handle(BiFunction<? super T, ? super Throwable, ? extends U> function) {
        return this.handle(function, DEFAULT_EXCEPTION_HANDLER);
    }

    public <U> Completable<U> handle(BiFunction<? super T, ? super Throwable, ? extends U> function, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(function, "Function may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new HandleTransform<U, T>(null, this, ret, exceptionHandler, function));
        return ret;
    }

    public <U> Completable<U> handleAsync(BiFunction<? super T, ? super Throwable, ? extends U> function) {
        return this.handleAsync(function, Completable.getDefaultExecutor(), DEFAULT_EXCEPTION_HANDLER);
    }

    public <U> Completable<U> handleAsync(BiFunction<? super T, ? super Throwable, ? extends U> function, Executor executor) {
        return this.handleAsync(function, executor, DEFAULT_EXCEPTION_HANDLER);
    }

    public <U> Completable<U> handleAsync(BiFunction<? super T, ? super Throwable, ? extends U> function, Executor executor, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(function, "Function may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new HandleTransform<U, T>(Completable.checkExecutor(executor), this, ret, exceptionHandler, function));
        return ret;
    }

    public Completable<T> whenComplete(BiConsumer<? super T, ? super Throwable> consumer) {
        return this.whenComplete(consumer, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<T> whenComplete(BiConsumer<? super T, ? super Throwable> consumer, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(consumer, "Consumer may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new WhenTransform<T>(null, this, ret, exceptionHandler, consumer));
        return ret;
    }

    public Completable<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> consumer) {
        return this.whenCompleteAsync(consumer, Completable.getDefaultExecutor(), DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> consumer, Executor executor) {
        return this.whenCompleteAsync(consumer, executor, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> consumer, Executor executor, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(consumer, "Consumer may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new WhenTransform<T>(Completable.checkExecutor(executor), this, ret, exceptionHandler, consumer));
        return ret;
    }

    public Completable<T> exceptionally(Function<Throwable, ? extends T> function) {
        return this.exceptionally(function, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<T> exceptionally(Function<Throwable, ? extends T> function, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(function, "Function may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new ExceptionallyTransform<T>(null, this, ret, exceptionHandler, function));
        return ret;
    }

    public Completable<T> exceptionallyAsync(Function<Throwable, ? extends T> function) {
        return this.exceptionallyAsync(function, Completable.getDefaultExecutor(), DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<T> exceptionallyAsync(Function<Throwable, ? extends T> function, Executor executor) {
        return this.exceptionallyAsync(function, executor, DEFAULT_EXCEPTION_HANDLER);
    }

    public Completable<T> exceptionallyAsync(Function<Throwable, ? extends T> function, Executor executor, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
        Objects.requireNonNull(function, "Function may not be null");
        Objects.requireNonNull(exceptionHandler, "Exception handler may not be null");
        Completable<T> ret = new Completable<T>();
        this.pushStackOrRun(new ExceptionallyTransform<T>(Completable.checkExecutor(executor), this, ret, exceptionHandler, function));
        return ret;
    }

    private static abstract class Transform<U, T>
    implements Runnable,
    CompletableFuture.AsynchronousCompletionTask {
        private Transform<?, T> next;
        private final Executor executor;
        protected final Completable<T> from;
        protected final Completable<U> to;
        protected final Function<? super Throwable, ? extends Throwable> exceptionHandler;

        protected Transform(Executor executor, Completable<T> from, Completable<U> to, Function<? super Throwable, ? extends Throwable> exceptionHandler) {
            this.executor = executor;
            this.from = from;
            this.to = to;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public abstract void run();

        protected void failed(Throwable throwable) {
            Throwable complete;
            try {
                complete = this.exceptionHandler.apply(throwable);
            }
            catch (Throwable thr2) {
                throwable.addSuppressed(thr2);
                complete = throwable;
            }
            this.to.completeExceptionally(complete);
        }

        public void execute() {
            if (this.executor == null) {
                this.run();
                return;
            }
            try {
                this.executor.execute(this);
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }

    private static final class ExceptionResult {
        public final Throwable ex;

        public ExceptionResult(Throwable ex) {
            this.ex = ex;
        }
    }

    private static final class UnparkTransform<T>
    extends Transform<Void, T>
    implements ForkJoinPool.ManagedBlocker {
        private volatile Thread thread;

        public UnparkTransform(Completable<T> from, Thread target) {
            super(null, from, null, null);
            this.thread = target;
        }

        @Override
        public void run() {
            Thread t = this.thread;
            this.thread = null;
            LockSupport.unpark(t);
        }

        @Override
        public boolean block() throws InterruptedException {
            while (!this.isReleasable()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                LockSupport.park(this);
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.thread == null;
        }
    }

    private static final class ApplyTransform<U, T>
    extends Transform<U, T> {
        private final Function<? super T, ? extends U> function;

        public ApplyTransform(Executor executor, Completable<T> from, Completable<U> to, Function<? super Throwable, ? extends Throwable> exceptionHandler, Function<? super T, ? extends U> function) {
            super(executor, from, to, exceptionHandler);
            this.function = function;
        }

        @Override
        public void run() {
            Object result = this.from.getResultPlain();
            try {
                if (result instanceof ExceptionResult) {
                    ExceptionResult exRes = (ExceptionResult)result;
                    this.to.completeExceptionally(exRes.ex);
                } else {
                    this.to.complete(this.function.apply(Completable.unmaskNull(result)));
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }

    private static final class AcceptTransform<T>
    extends Transform<Void, T> {
        private final Consumer<? super T> consumer;

        public AcceptTransform(Executor executor, Completable<T> from, Completable<Void> to, Function<? super Throwable, ? extends Throwable> exceptionHandler, Consumer<? super T> consumer) {
            super(executor, from, to, exceptionHandler);
            this.consumer = consumer;
        }

        @Override
        public void run() {
            Object result = this.from.getResultPlain();
            try {
                if (result instanceof ExceptionResult) {
                    ExceptionResult exRes = (ExceptionResult)result;
                    this.to.completeExceptionally(exRes.ex);
                } else {
                    this.consumer.accept(Completable.unmaskNull(result));
                    this.to.complete(null);
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }

    private static final class RunTransform<T>
    extends Transform<Void, T> {
        private final Runnable run;

        public RunTransform(Executor executor, Completable<T> from, Completable<Void> to, Function<? super Throwable, ? extends Throwable> exceptionHandler, Runnable run) {
            super(executor, from, to, exceptionHandler);
            this.run = run;
        }

        @Override
        public void run() {
            Object result = this.from.getResultPlain();
            try {
                if (result instanceof ExceptionResult) {
                    ExceptionResult exRes = (ExceptionResult)result;
                    this.to.completeExceptionally(exRes.ex);
                } else {
                    this.run.run();
                    this.to.complete(null);
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }

    private static final class HandleTransform<U, T>
    extends Transform<U, T> {
        private final BiFunction<? super T, ? super Throwable, ? extends U> function;

        public HandleTransform(Executor executor, Completable<T> from, Completable<U> to, Function<? super Throwable, ? extends Throwable> exceptionHandler, BiFunction<? super T, ? super Throwable, ? extends U> function) {
            super(executor, from, to, exceptionHandler);
            this.function = function;
        }

        @Override
        public void run() {
            Object result = this.from.getResultPlain();
            try {
                if (result instanceof ExceptionResult) {
                    ExceptionResult exRes = (ExceptionResult)result;
                    this.to.complete(this.function.apply(null, exRes.ex));
                } else {
                    this.to.complete(this.function.apply(Completable.unmaskNull(result), null));
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }

    private static final class WhenTransform<T>
    extends Transform<T, T> {
        private final BiConsumer<? super T, ? super Throwable> consumer;

        public WhenTransform(Executor executor, Completable<T> from, Completable<T> to, Function<? super Throwable, ? extends Throwable> exceptionHandler, BiConsumer<? super T, ? super Throwable> consumer) {
            super(executor, from, to, exceptionHandler);
            this.consumer = consumer;
        }

        @Override
        public void run() {
            Object result = this.from.getResultPlain();
            try {
                if (result instanceof ExceptionResult) {
                    ExceptionResult exRes = (ExceptionResult)result;
                    this.consumer.accept(null, exRes.ex);
                    this.to.completeExceptionally(exRes.ex);
                } else {
                    Object unmasked = Completable.unmaskNull(result);
                    this.consumer.accept(unmasked, null);
                    this.to.complete(unmasked);
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }

    private static final class ExceptionallyTransform<T>
    extends Transform<T, T> {
        private final Function<Throwable, ? extends T> function;

        public ExceptionallyTransform(Executor executor, Completable<T> from, Completable<T> to, Function<? super Throwable, ? extends Throwable> exceptionHandler, Function<Throwable, ? extends T> function) {
            super(executor, from, to, exceptionHandler);
            this.function = function;
        }

        @Override
        public void run() {
            Object result = this.from.getResultPlain();
            try {
                if (result instanceof ExceptionResult) {
                    ExceptionResult exRes = (ExceptionResult)result;
                    this.to.complete(this.function.apply(exRes.ex));
                } else {
                    this.to.complete(Completable.unmaskNull(result));
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }
}

