/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.numa;

import ca.spottedleaf.concurrentutil.numa.OSNuma;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;

public final class LinuxNuma
extends OSNuma.PreCalculatedNuma {
    private static final ThreadLocal<IntByReference> CURRENT_CORE_POINTER = ThreadLocal.withInitial(IntByReference::new);
    private static final boolean LIBRARIES_AVAILABLE;
    public static final LinuxNuma INSTANCE;

    private LinuxNuma(int[] coreToNuma, int[][] costArray) {
        super(coreToNuma, costArray);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private static int getCurrentCore0() {
        IntByReference cpu = CURRENT_CORE_POINTER.get();
        int res = LibC.getcpu(cpu, null);
        if (res == 0) {
            return cpu.getValue();
        }
        throw new IllegalStateException("getcpu failed: " + res);
    }

    @Override
    public int getCurrentCore() {
        return LinuxNuma.getCurrentCore0();
    }

    private static long[] getCurrentThreadAffinity0() {
        int cpus = LibNuma.numa_num_possible_cpus();
        if (cpus < 0) {
            throw new IllegalStateException();
        }
        CpuSet cpuSet = new CpuSet(cpus);
        int res = LibC.sched_getaffinity(0, (int)cpuSet.sizeof(), cpuSet.getPointer());
        if (res != 0) {
            throw new IllegalStateException();
        }
        return cpuSet.toLongs();
    }

    @Override
    public long[] getCurrentThreadAffinity() {
        return LinuxNuma.getCurrentThreadAffinity0();
    }

    private static void setCurrentThreadAffinity0(long[] to) {
        CpuSet cpuSet = new CpuSet(to);
        LibC.sched_setaffinity(0, (int)cpuSet.sizeof(), cpuSet.getPointer());
    }

    @Override
    public void setCurrentThreadAffinity(long[] to) {
        LinuxNuma.setCurrentThreadAffinity0(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean librariesOk = false;
        try {
            LibNuma.init();
            LibC.init();
            librariesOk = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!librariesOk) {
            LIBRARIES_AVAILABLE = false;
        } else {
            boolean bl = LIBRARIES_AVAILABLE = LibNuma.numa_available() >= 0;
        }
        if (!LIBRARIES_AVAILABLE) {
            INSTANCE = null;
        } else {
            int totalNumaNodes = LibNuma.numa_max_node() + 1;
            Pointer cpuMask = LibNuma.numa_allocate_cpumask();
            try {
                if (cpuMask == null) {
                    INSTANCE = null;
                } else {
                    int totalCpus = LibNuma.numa_num_possible_cpus();
                    int[] coreToNuma = new int[]{};
                    for (int node = 0; node < totalNumaNodes; ++node) {
                        LibNuma.numa_bitmask_clearall(cpuMask);
                        int res = LibNuma.numa_node_to_cpus(node, cpuMask);
                        if (res != 0) {
                            coreToNuma = null;
                            break;
                        }
                        for (int cpu = 0; cpu < totalCpus; ++cpu) {
                            int bit = LibNuma.numa_bitmask_isbitset(cpuMask, cpu);
                            if (bit == 0 || coreToNuma.length > cpu) continue;
                            coreToNuma = Arrays.copyOf(coreToNuma, cpu + 1);
                            coreToNuma[cpu] = node;
                        }
                    }
                    int[][] costArray = new int[totalNumaNodes][totalNumaNodes];
                    for (int i = 0; i < totalNumaNodes; ++i) {
                        for (int j = 0; j < totalNumaNodes; ++j) {
                            int dist = LibNuma.numa_distance(i, j);
                            costArray[i][j] = dist <= 0 ? 255 : dist;
                        }
                    }
                    INSTANCE = coreToNuma == null ? null : new LinuxNuma(coreToNuma, costArray);
                }
            }
            finally {
                if (cpuMask != null) {
                    LibNuma.numa_bitmask_free(cpuMask);
                }
            }
        }
    }

    private static final class LibC {
        private LibC() {
        }

        public static void init() {
        }

        public static native int getcpu(IntByReference var0, IntByReference var1);

        public static native int sched_setaffinity(int var0, int var1, Pointer var2);

        public static native int sched_getaffinity(int var0, int var1, Pointer var2);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }
    }

    private static final class LibNuma {
        private LibNuma() {
        }

        public static void init() {
        }

        public static native int numa_available();

        public static native int numa_max_node();

        public static native int numa_distance(int var0, int var1);

        public static native Pointer numa_allocate_cpumask();

        public static native Pointer numa_bitmask_clearall(Pointer var0);

        public static native int numa_bitmask_isbitset(Pointer var0, int var1);

        public static native int numa_node_to_cpus(int var0, Pointer var1);

        public static native void numa_bitmask_free(Pointer var0);

        public static native int numa_num_possible_cpus();

        static {
            Native.register((String)"numa");
        }
    }

    private static final class CpuSet
    extends ByReference {
        private static int roundLongSizeBits(int bits) {
            int bytes = (bits + 7) / 8;
            return CpuSet.roundLongSizeBytes(bytes);
        }

        private static int roundLongSizeBytes(int bytes) {
            int longs = (bytes + (Native.LONG_SIZE - 1)) / Native.LONG_SIZE;
            return longs * Native.LONG_SIZE;
        }

        public CpuSet(int bits) {
            super(CpuSet.roundLongSizeBits(bits));
        }

        public CpuSet(long[] bitset) {
            super(CpuSet.roundLongSizeBytes(bitset.length * 8));
            for (int i = 0; i < bitset.length; ++i) {
                this.getPointer().setLong((long)i << 3, bitset[i]);
            }
        }

        public long[] toLongs() {
            long[] ret = new long[(int)((this.sizeof() + 7L) / 8L)];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.getPointer().getLong((long)i << 3);
            }
            return ret;
        }

        public long sizeof() {
            return ((Memory)this.getPointer()).size();
        }
    }
}

