/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.numa;

import ca.spottedleaf.concurrentutil.numa.LinuxNuma;
import ca.spottedleaf.concurrentutil.util.FlatBitsetUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public interface OSNuma {
    public static OSNuma getNativeInstance() {
        LinuxNuma linux = LinuxNuma.INSTANCE;
        if (linux != null && linux.isAvailable()) {
            return linux;
        }
        return NoOp.INSTANCE;
    }

    public boolean isAvailable();

    public int getNumaDistance(int var1, int var2);

    public int getTotalNumaNodes();

    public int[][] getNodeDistances();

    public int getNumaNode(int var1);

    public int getTotalCores();

    public int[] getCores(int var1);

    public int getCurrentNumaNode();

    public int getCurrentCore();

    public long[] getCurrentThreadAffinity();

    public void setCurrentThreadAffinity(long[] var1);

    default public void setCurrentNumaAffinity(long[] to) {
        this.setCurrentNumaAffinity(FlatBitsetUtil.bitsetToInts(to));
    }

    default public void setCurrentNumaAffinity(int[] numaNodes) {
        IntArrayList cores = new IntArrayList();
        for (int node : numaNodes) {
            cores.addAll((IntList)IntArrayList.wrap((int[])this.getCores(node)));
        }
        this.setCurrentThreadAffinity(FlatBitsetUtil.intsToBitset(cores.toIntArray()));
    }

    public static final class NoOp
    extends PreCalculatedNuma {
        public static final NoOp INSTANCE = new NoOp();
        private final long[] currentThreadAffinity = FlatBitsetUtil.intsToBitset(this.getCores(0));

        private NoOp() {
            super(new int[Runtime.getRuntime().availableProcessors()], new int[][]{{10}});
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public int getCurrentCore() {
            return 0;
        }

        @Override
        public long[] getCurrentThreadAffinity() {
            return (long[])this.currentThreadAffinity.clone();
        }

        @Override
        public void setCurrentThreadAffinity(long[] to) {
        }
    }

    public static abstract class PreCalculatedNuma
    implements OSNuma {
        private final int[] coreToNuma;
        private final int[][] costArray;
        private final int[][] numaToCore;

        public PreCalculatedNuma(int[] coreToNuma, int[][] costArray) {
            int i;
            this.coreToNuma = coreToNuma;
            this.costArray = costArray;
            IntArrayList[] numaToCore = new IntArrayList[this.costArray.length];
            for (i = 0; i < numaToCore.length; ++i) {
                numaToCore[i] = new IntArrayList();
            }
            for (int core = 0; core < coreToNuma.length; ++core) {
                numaToCore[coreToNuma[core]].add(core);
            }
            this.numaToCore = new int[this.costArray.length][];
            for (i = 0; i < this.numaToCore.length; ++i) {
                this.numaToCore[i] = numaToCore[i].toIntArray();
            }
        }

        @Override
        public int getNumaDistance(int n1, int n2) {
            if (n1 < 0 || n1 >= this.costArray.length) {
                return 0;
            }
            int[] distances = this.costArray[n1];
            if (n2 < 0 || n2 >= distances.length) {
                return 0;
            }
            return distances[n2];
        }

        @Override
        public int getTotalNumaNodes() {
            return this.costArray.length;
        }

        @Override
        public int[][] getNodeDistances() {
            int[][] ret = new int[this.costArray.length][];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (int[])this.costArray[i].clone();
            }
            return ret;
        }

        @Override
        public int getNumaNode(int coreId) {
            if (coreId < 0 || coreId >= this.coreToNuma.length) {
                return -1;
            }
            return this.coreToNuma[coreId];
        }

        @Override
        public int getTotalCores() {
            return this.coreToNuma.length;
        }

        @Override
        public int[] getCores(int numaId) {
            if (numaId < 0 || numaId >= this.numaToCore.length) {
                return null;
            }
            return (int[])this.numaToCore[numaId].clone();
        }

        @Override
        public int getCurrentNumaNode() {
            return this.coreToNuma[this.getCurrentCore()];
        }
    }
}

