/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.scheduler;

import ca.spottedleaf.concurrentutil.list.COWArrayList;
import ca.spottedleaf.concurrentutil.numa.OSNuma;
import ca.spottedleaf.concurrentutil.scheduler.SchedulableTick;
import ca.spottedleaf.concurrentutil.scheduler.Scheduler;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.TimeUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.invoke.VarHandle;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;

public final class StealingScheduledThreadPool
extends Scheduler {
    public static final long FLAG_SCHEDULE_EVENLY = 1L;
    public static final long FLAG_SCHEDULE_NEAR = 2L;
    public static final long DEFAULT_FLAGS = 1L;
    private final ThreadFactory threadFactory;
    private final OSNuma numa;
    private final COWArrayList<TickThreadRunner> coreThreads = new COWArrayList<TickThreadRunner>(TickThreadRunner.class);
    private final COWArrayList<TickThreadRunner> aliveThreads = new COWArrayList<TickThreadRunner>(TickThreadRunner.class);
    private final COWArrayList<NodeThreads> nodes = new COWArrayList<NodeThreads>(NodeThreads.class);
    private final ReferenceOpenHashSet<SchedulableTick> allTasks = new ReferenceOpenHashSet();
    private boolean shutdown;
    private long stealThresholdNS;
    private long taskTimeSliceNS;
    private long flags;

    public StealingScheduledThreadPool(ThreadFactory threadFactory, OSNuma numa) {
        this.threadFactory = threadFactory;
        this.numa = numa;
        if (threadFactory == null) {
            throw new NullPointerException("Null thread factory");
        }
        this.setFlags(1L);
    }

    public OSNuma getNuma() {
        return this.numa;
    }

    private static ScheduledState getState(SchedulableTick tick) {
        return (ScheduledState)tick.state;
    }

    private static Thread[] getThreads(COWArrayList<TickThreadRunner> runners) {
        TickThreadRunner[] array = runners.getArray();
        Thread[] ret = new Thread[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = array[i].thread;
        }
        return ret;
    }

    @Override
    public Thread[] getAliveThreads() {
        return StealingScheduledThreadPool.getThreads(this.aliveThreads);
    }

    @Override
    public Thread[] getCoreThreads() {
        return StealingScheduledThreadPool.getThreads(this.coreThreads);
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setThreadAllocation(Int2IntMap threadsPerNode, long stealThresholdNS, long taskTimeSliceNS) {
        Object runner;
        if (this.shutdown) {
            return false;
        }
        this.stealThresholdNS = stealThresholdNS;
        this.taskTimeSliceNS = taskTimeSliceNS;
        NodeThreads[] nodes = new NodeThreads[threadsPerNode.size()];
        ArrayList<TickThreadRunner> newRunners = new ArrayList<TickThreadRunner>();
        int nodesIndex = 0;
        for (TickThreadRunner[] entry : threadsPerNode.int2IntEntrySet()) {
            int node = entry.getIntKey();
            int threads = entry.getIntValue();
            TickThreadRunner[] runners = new TickThreadRunner[threads];
            NodeThreads nodeThreads = new NodeThreads(runners, node);
            for (int i = 0; i < threads; ++i) {
                runner = new TickThreadRunner[1];
                Runnable run = () -> StealingScheduledThreadPool.lambda$setThreadAllocation$0((TickThreadRunner[])runner);
                runners[i] = runner[0] = new TickThreadRunner(this.threadFactory.newThread(run), this, nodeThreads, nodes);
                newRunners.add(runners[i]);
                this.aliveThreads.add(runners[i]);
            }
            nodes[nodesIndex++] = nodeThreads;
        }
        LongOpenHashSet oldRunners = new LongOpenHashSet(this.coreThreads.getArray().length);
        for (TickThreadRunner oldRunner : this.coreThreads.getArray()) {
            oldRunners.add(oldRunner.id);
            oldRunner.halt();
        }
        this.coreThreads.set((TickThreadRunner[])newRunners.toArray(new TickThreadRunner[0]));
        this.nodes.set((NodeThreads[])nodes);
        SchedulableTick[] node = this.allTasks;
        synchronized (this.allTasks) {
            SchedulableTick[] allTasks = (SchedulableTick[])this.allTasks.toArray((Object[])new SchedulableTick[0]);
            // ** MonitorExit[node] (shouldn't be in output)
            for (SchedulableTick tick : allTasks) {
                ScheduledState state = StealingScheduledThreadPool.getState(tick);
                runner = state.getOwnedBy();
                if (runner != null && !oldRunners.contains(runner.id)) continue;
                TickThreadRunner newRunner = this.selectRunner((TickThreadRunner)runner, this.nodes.getArray());
                if (newRunner == runner) {
                    if (runner == null) continue;
                    throw new IllegalStateException();
                }
                state.transferScheduling((TickThreadRunner)runner, newRunner);
            }
            if (this.numa.isAvailable()) {
                long[] prevAffinity = this.numa.getCurrentThreadAffinity();
                try {
                    for (NodeThreads node2 : this.nodes.getArray()) {
                        this.numa.setCurrentNumaAffinity(new int[]{node2.nodeNumber});
                        for (TickThreadRunner runner2 : node2.threads) {
                            runner2.thread.start();
                        }
                    }
                }
                finally {
                    this.numa.setCurrentThreadAffinity(prevAffinity);
                }
            } else {
                for (TickThreadRunner runner3 : this.coreThreads.getArray()) {
                    runner3.thread.start();
                }
            }
            return true;
        }
    }

    public synchronized boolean setFlags(long flags) {
        if (this.shutdown) {
            return false;
        }
        this.flags = flags;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void die(TickThreadRunner runner) {
        StealingScheduledThreadPool stealingScheduledThreadPool = this;
        synchronized (stealingScheduledThreadPool) {
            this.aliveThreads.remove(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void halt() {
        TickThreadRunner[] tickThreadRunnerArray = this;
        synchronized (this) {
            this.shutdown = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (TickThreadRunner runner : this.coreThreads.getArray()) {
                runner.halt();
            }
            return;
        }
    }

    @Override
    public boolean join(long msToWait) {
        try {
            return this.join(msToWait, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public boolean joinInterruptable(long msToWait) throws InterruptedException {
        return this.join(msToWait, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean join(long msToWait, boolean interruptable) throws InterruptedException {
        var4_3 = this;
        synchronized (var4_3) {
            if (!this.shutdown) {
                throw new IllegalStateException("Attempting to join on non-shutdown pool");
            }
        }
        nsToWait = TimeUnit.MILLISECONDS.toNanos(msToWait);
        start = System.nanoTime();
        deadline = start + nsToWait;
        interrupted = false;
        try {
            for (TickThreadRunner runner : this.aliveThreads.getArray()) {
                thread = runner.thread;
                while (thread.isAlive()) {
                    block15: {
                        if (msToWait <= 0L) ** GOTO lbl28
                        current = System.nanoTime();
                        if (current - deadline < 0L) break block15;
                        var18_17 = false;
                        return var18_17;
                    }
                    try {
                        thread.join(Duration.ofNanos(deadline - current));
                        continue;
lbl28:
                        // 1 sources

                        thread.join();
                    }
                    catch (InterruptedException ex) {
                        if (interruptable) {
                            throw ex;
                        }
                        interrupted = true;
                    }
                }
            }
            var11_10 = true;
            return var11_10;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private TickThreadRunner selectRunner(TickThreadRunner previousRunner, NodeThreads[] nodes) {
        int currentNode;
        int n = currentNode = previousRunner == null ? this.numa.getCurrentNumaNode() : previousRunner.node.nodeNumber;
        if ((this.flags & 2L) != 0L) {
            TickThreadRunner selected = null;
            int selectedDistance = Integer.MAX_VALUE;
            int selectedSize = Integer.MAX_VALUE;
            for (NodeThreads node : nodes) {
                int distance = this.numa.getNumaDistance(currentNode, node.nodeNumber);
                if (distance > selectedDistance) continue;
                for (TickThreadRunner runner : node.threads) {
                    int size = runner.tickQueue.size();
                    if (distance >= selectedDistance && size >= selectedSize) continue;
                    selected = runner;
                    selectedDistance = distance;
                    selectedSize = size;
                }
            }
            return selected;
        }
        TickThreadRunner selected = null;
        int selectedSize = Integer.MAX_VALUE;
        int selectedDistance = Integer.MAX_VALUE;
        for (NodeThreads node : nodes) {
            int distance = this.numa.getNumaDistance(currentNode, node.nodeNumber);
            for (TickThreadRunner runner : node.threads) {
                int size = runner.tickQueue.size();
                if (size >= selectedSize && (size != selectedSize || distance >= selectedDistance)) continue;
                selected = runner;
                selectedSize = size;
                selectedDistance = distance;
            }
        }
        return selected;
    }

    @Override
    public void schedule(SchedulableTick tick) {
        NodeThreads[] nodes = this.nodes.getArray();
        ScheduledState state = new ScheduledState(tick);
        if (!tick.setState(state)) {
            throw new IllegalStateException("Task is already scheduled");
        }
        TickThreadRunner initialRunner = this.selectRunner(null, nodes);
        if (!state.initScheduling(this, initialRunner)) {
            throw new IllegalStateException("Task is already scheduled");
        }
        if (nodes != (nodes = this.nodes.getArray())) {
            state.transferScheduling(initialRunner, this.selectRunner(null, nodes));
        }
        if (tick.hasTasks()) {
            this.notifyTasks(tick);
        }
    }

    @Override
    public void notifyTasks(SchedulableTick tick) {
        Object object = tick.state;
        if (object instanceof ScheduledState) {
            ScheduledState state = (ScheduledState)object;
            state.scheduleTasks();
        }
    }

    @Override
    public boolean cancel(SchedulableTick tick) {
        Object object = tick.state;
        if (object instanceof ScheduledState) {
            ScheduledState state = (ScheduledState)object;
            return state.tryCancel();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickAdded(ScheduledState tick) {
        ReferenceOpenHashSet<SchedulableTick> referenceOpenHashSet = this.allTasks;
        synchronized (referenceOpenHashSet) {
            this.allTasks.add((Object)tick.tick);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickCancelled(ScheduledState tick) {
        ReferenceOpenHashSet<SchedulableTick> referenceOpenHashSet = this.allTasks;
        synchronized (referenceOpenHashSet) {
            this.allTasks.remove((Object)tick.tick);
        }
    }

    private static /* synthetic */ void lambda$setThreadAllocation$0(TickThreadRunner[] runner) {
        runner[0].run();
    }

    private static final class TickThreadRunner
    implements Runnable {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final long id = ID_GENERATOR.getAndIncrement();
        private static final long MAX_IDLE_TIME = TimeUnit.MILLISECONDS.toNanos(10L);
        private final Thread thread;
        private final StealingScheduledThreadPool scheduler;
        private final NodeThreads node;
        private final NodeThreads[] nodes;
        private static final int STATE_NOT_STARTED = 1;
        private static final int STATE_IDLE = 2;
        private static final int STATE_INTERRUPTED = 4;
        private static final int STATE_EXECUTING_TASKS = 8;
        private static final int STATE_EXECUTING_TICK = 16;
        private static final int STATE_HALTED = 32;
        private volatile int state = 1;
        private static final VarHandle STATE_HANDLE = ConcurrentUtil.getVarHandle(TickThreadRunner.class, "state", Integer.TYPE);
        private final ConcurrentSkipListMap<TickScheduleHolder, Boolean> tickQueue = new ConcurrentSkipListMap(TickScheduleHolder.COMPARATOR);
        private final ConcurrentSkipListMap<TaskScheduleHolder, Boolean> taskQueue = new ConcurrentSkipListMap(TaskScheduleHolder.COMPARATOR);

        private int getStateVolatile() {
            return STATE_HANDLE.getVolatile(this);
        }

        private void setStateVolatile(int value) {
            STATE_HANDLE.setVolatile(this, value);
        }

        private int exchangeStateVolatile(int value) {
            return STATE_HANDLE.getAndSet(this, value);
        }

        private int compareAndExchangeStateVolatile(int expect, int update) {
            return STATE_HANDLE.compareAndExchange(this, expect, update);
        }

        private TickThreadRunner(Thread thread, StealingScheduledThreadPool scheduler, NodeThreads node, NodeThreads[] nodes) {
            this.thread = thread;
            this.scheduler = scheduler;
            this.node = node;
            this.nodes = nodes;
        }

        private void interruptIfIdle() {
            int state = this.getStateVolatile();
            if (state == 2 && state == this.compareAndExchangeStateVolatile(state, 4)) {
                LockSupport.unpark(this.thread);
            }
        }

        private void halt() {
            if (2 == this.exchangeStateVolatile(32)) {
                LockSupport.unpark(this.thread);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void tryInterrupt() {
            state = this.getStateVolatile();
            failures = 0;
            block5: while (true) lbl-1000:
            // 4 sources

            {
                for (i = 0; i < failures; ++i) {
                    ConcurrentUtil.backoff();
                }
                ++failures;
                switch (state) {
                    case 2: {
                        if (state != (state = this.compareAndExchangeStateVolatile(state, 4))) ** GOTO lbl-1000
                        LockSupport.unpark(this.thread);
                        return;
                    }
                    case 8: {
                        if (state != (state = this.compareAndExchangeStateVolatile(state, 4))) continue block5;
                        return;
                    }
                    case 1: 
                    case 4: 
                    case 16: 
                    case 32: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown state: " + state);
        }

        private TickScheduleHolder findFirstTick() {
            Map.Entry<TickScheduleHolder, Boolean> first = this.tickQueue.firstEntry();
            return first == null ? null : first.getKey();
        }

        private TaskScheduleHolder findFirstTask() {
            Map.Entry<TaskScheduleHolder, Boolean> first = this.taskQueue.firstEntry();
            return first == null ? null : first.getKey();
        }

        private void tryStealTask() {
            TickScheduleHolder ourDeadlineHolder = this.findFirstTick();
            long ourEarliest = ourDeadlineHolder == null ? Long.MIN_VALUE : ourDeadlineHolder.atNS;
            long now = System.nanoTime();
            long stealThreshold = this.scheduler.stealThresholdNS;
            ScheduledState selected = null;
            long selectedBehindAdjusted = Long.MIN_VALUE;
            int selectedDistance = Integer.MAX_VALUE;
            TickThreadRunner selectedRunner = null;
            for (NodeThreads node : this.nodes) {
                int distance = this.scheduler.numa.getNumaDistance(this.node.nodeNumber, node.nodeNumber);
                for (TickThreadRunner runner : node.threads) {
                    long behindAdjusted;
                    long behindBy;
                    TickScheduleHolder holder;
                    if (runner == this || (holder = runner.findFirstTick()) == null || holder.stolen) continue;
                    long holderStart = holder.atNS;
                    if (ourEarliest != Long.MIN_VALUE && (long)TimeUtil.compareTimes(holderStart, ourEarliest) >= 0L || (behindBy = now - holderStart) < stealThreshold || (behindAdjusted = behindBy / (long)distance) <= selectedBehindAdjusted && (behindAdjusted != selectedBehindAdjusted || distance >= selectedDistance)) continue;
                    selected = holder.tick;
                    selectedBehindAdjusted = behindAdjusted;
                    selectedDistance = distance;
                    selectedRunner = runner;
                }
            }
            if (selected != null && selected.trySteal(selectedRunner, this)) {
                this.tryInterrupt();
            }
        }

        private void begin() {
            if (this.scheduler.numa.isAvailable()) {
                this.scheduler.numa.setCurrentNumaAffinity(new int[]{this.node.nodeNumber});
            }
            this.compareAndExchangeStateVolatile(1, 4);
        }

        private void doRun() {
            while (this.mainLoop()) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeTasksUntil(long deadline) {
            long timeSlice = this.scheduler.taskTimeSliceNS;
            while (true) {
                this.tryStealTask();
                TaskScheduleHolder taskHolder = this.findFirstTask();
                if (taskHolder == null) {
                    while (this.getStateVolatile() == 2) {
                        Thread.interrupted();
                        long sleep = deadline - System.nanoTime();
                        if (sleep <= 0L) {
                            return true;
                        }
                        LockSupport.parkNanos("Awaiting deadline", Math.min(sleep, MAX_IDLE_TIME));
                    }
                    return false;
                }
                if (deadline - System.nanoTime() <= 0L) {
                    return true;
                }
                if (2 != this.compareAndExchangeStateVolatile(2, 8)) {
                    return false;
                }
                if (null == this.taskQueue.remove(taskHolder)) {
                    this.compareAndExchangeStateVolatile(8, 2);
                    continue;
                }
                ScheduledState task = taskHolder.task;
                if (task.trySetRunning(this)) {
                    boolean cancel = false;
                    try {
                        long start = System.nanoTime();
                        long toEndAt = TimeUtil.getLeastTime(deadline, start + timeSlice);
                        BooleanSupplier canContinueTasks = () -> {
                            if (this.getStateVolatile() != 8) {
                                return false;
                            }
                            return System.nanoTime() - toEndAt < 0L;
                        };
                        cancel = !task.tick.runTasks(canContinueTasks);
                    }
                    finally {
                        task.finishTaskExecution(cancel);
                    }
                }
                if (task.tick.hasTasks()) {
                    this.scheduler.notifyTasks(task.tick);
                }
                this.compareAndExchangeStateVolatile(8, 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tick(TickScheduleHolder tickHolder) {
            if (!this.executeTasksUntil(tickHolder.atNS)) {
                return;
            }
            if (2 != this.compareAndExchangeStateVolatile(2, 16)) {
                return;
            }
            if (null == this.tickQueue.remove(tickHolder)) {
                this.compareAndExchangeStateVolatile(16, 2);
                return;
            }
            ScheduledState tick = tickHolder.tick;
            if (tick.trySetRunning(this)) {
                boolean cancel = false;
                try {
                    cancel = !tick.tick.runTick();
                }
                finally {
                    tick.finishTickExecution(cancel);
                }
            }
            if (tick.tick.hasTasks()) {
                this.scheduler.notifyTasks(tick.tick);
            }
            this.compareAndExchangeStateVolatile(16, 4);
        }

        private boolean mainLoop() {
            while (this.getStateVolatile() == 2) {
                this.tryStealTask();
                Thread.interrupted();
                LockSupport.parkNanos("Idle parking", MAX_IDLE_TIME);
            }
            if (4 != this.compareAndExchangeStateVolatile(4, 2)) {
                int curr = this.getStateVolatile();
                if (32 != curr) {
                    throw new IllegalStateException("Unknown state: " + curr);
                }
                return false;
            }
            TickScheduleHolder toTick = this.findFirstTick();
            if (toTick == null) {
                this.tryStealTask();
                return true;
            }
            this.tick(toTick);
            return true;
        }

        private void die() {
            this.scheduler.die(this);
        }

        @Override
        public void run() {
            try {
                this.begin();
                this.doRun();
            }
            finally {
                this.die();
            }
        }
    }

    private static final class NodeThreads {
        private final TickThreadRunner[] threads;
        private final int nodeNumber;

        private NodeThreads(TickThreadRunner[] threads, int nodeNumber) {
            this.threads = threads;
            this.nodeNumber = nodeNumber;
        }
    }

    private static final class ScheduledState {
        private final SchedulableTick tick;
        private StealingScheduledThreadPool scheduledTo;
        private TickThreadRunner ownedBy;
        private TickScheduleHolder tickScheduleHolder;
        private TaskScheduleHolder taskScheduleHolder;
        private static final int STATE_UNSCHEDULED = 1;
        private static final int STATE_IDLE = 2;
        private static final int STATE_HAS_TASKS = 4;
        private static final int STATE_RUNNING = 8;
        private static final int STATE_RUNNING_CANCELLED = 16;
        private static final int STATE_CANCELLED = 32;
        private volatile int state = 1;

        private ScheduledState(SchedulableTick tick) {
            this.tick = tick;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TickThreadRunner getOwnedBy() {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                return this.ownedBy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean initScheduling(StealingScheduledThreadPool threadPool, TickThreadRunner runner) {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                if (this.state != 1) {
                    return false;
                }
                long scheduledStart = this.tick.scheduledStart;
                if (scheduledStart == Long.MIN_VALUE) {
                    throw new IllegalStateException("Start must be set when scheduling");
                }
                threadPool.tickAdded(this);
                this.scheduledTo = threadPool;
                if (runner != null) {
                    this.ownedBy = runner;
                    this.tickScheduleHolder = new TickScheduleHolder(this, scheduledStart, false);
                    runner.tickQueue.put(this.tickScheduleHolder, Boolean.TRUE);
                    if (runner.findFirstTick() == this.tickScheduleHolder) {
                        runner.interruptIfIdle();
                    }
                }
                this.state = 2;
                return true;
            }
        }

        private boolean transferScheduling(TickThreadRunner from, TickThreadRunner to) {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                if (this.ownedBy != from) {
                    return false;
                }
                switch (this.state) {
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        this.ownedBy = to;
                        this.reschedule(false);
                        if (this.taskScheduleHolder != null) {
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    case 4: {
                        this.ownedBy = to;
                        this.reschedule(false);
                        if (to == null) {
                            this.taskScheduleHolder = null;
                        } else if (this.taskScheduleHolder != null) {
                            this.taskScheduleHolder = new TaskScheduleHolder(this, this.taskScheduleHolder.lastDrainedTasks);
                            to.taskQueue.put(this.taskScheduleHolder, Boolean.TRUE);
                            to.interruptIfIdle();
                        }
                        return true;
                    }
                    case 8: {
                        this.ownedBy = to;
                        this.tickScheduleHolder = null;
                        this.taskScheduleHolder = null;
                        return true;
                    }
                    case 16: 
                    case 32: {
                        return false;
                    }
                }
                throw new IllegalStateException("Unknown state: " + this.state);
            }
        }

        private boolean trySteal(TickThreadRunner from, TickThreadRunner to) {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                if (this.ownedBy != from) {
                    return false;
                }
                switch (this.state) {
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        this.ownedBy = to;
                        this.reschedule(true);
                        if (this.taskScheduleHolder != null) {
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    case 4: {
                        this.ownedBy = to;
                        this.reschedule(true);
                        if (to == null) {
                            this.taskScheduleHolder = null;
                        } else if (this.taskScheduleHolder != null) {
                            this.taskScheduleHolder = new TaskScheduleHolder(this, this.taskScheduleHolder.lastDrainedTasks);
                            to.taskQueue.put(this.taskScheduleHolder, Boolean.TRUE);
                            to.interruptIfIdle();
                        }
                        return true;
                    }
                    case 8: 
                    case 16: 
                    case 32: {
                        return false;
                    }
                }
                throw new IllegalStateException("Unknown state: " + this.state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleTasks() {
            int currState = this.state;
            if (currState != 2) {
                return;
            }
            long now = System.nanoTime();
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                if (this.state != 2) {
                    return;
                }
                this.taskScheduleHolder = new TaskScheduleHolder(this, now);
                if (this.ownedBy != null) {
                    this.ownedBy.taskQueue.put(this.taskScheduleHolder, Boolean.TRUE);
                    if (Thread.currentThread() != this.ownedBy.thread) {
                        this.ownedBy.interruptIfIdle();
                    }
                }
                this.state = 4;
            }
        }

        private void reschedule(boolean stolen) {
            long scheduledStart = this.tick.scheduledStart;
            if (scheduledStart == Long.MIN_VALUE) {
                throw new IllegalStateException("Start must be set when scheduling");
            }
            if (this.ownedBy != null) {
                this.tickScheduleHolder = new TickScheduleHolder(this, scheduledStart, stolen);
                this.ownedBy.tickQueue.put(this.tickScheduleHolder, Boolean.TRUE);
                if (Thread.currentThread() != this.ownedBy.thread && this.ownedBy.findFirstTick() == this.tickScheduleHolder) {
                    this.ownedBy.tryInterrupt();
                }
            }
        }

        private boolean trySetRunning(TickThreadRunner expectedOwner) {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                if (this.ownedBy != expectedOwner) {
                    return false;
                }
                switch (this.state) {
                    case 1: {
                        throw new IllegalStateException("Cannot be unscheduled here");
                    }
                    case 2: 
                    case 4: {
                        this.state = 8;
                        return true;
                    }
                    case 8: 
                    case 16: 
                    case 32: {
                        return false;
                    }
                }
                throw new IllegalStateException("Unknown state: " + this.state);
            }
        }

        private boolean tryCancel() {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                switch (this.state) {
                    case 1: {
                        return false;
                    }
                    case 2: 
                    case 4: {
                        this.doCancel();
                        return true;
                    }
                    case 8: {
                        this.state = 16;
                        return true;
                    }
                    case 16: 
                    case 32: {
                        return false;
                    }
                }
                throw new IllegalStateException("Unknown state: " + this.state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishTaskExecution(boolean cancel) {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                if (this.state != 8 && this.state != 16) {
                    throw new IllegalStateException("Must be running here");
                }
                if (cancel || this.state == 16) {
                    this.doCancel();
                    return;
                }
                this.taskScheduleHolder = null;
                if (this.tickScheduleHolder == null) {
                    this.reschedule(false);
                }
                this.state = 2;
            }
        }

        private void doCancel() {
            if (this.tickScheduleHolder != null) {
                if (this.ownedBy != null) {
                    this.ownedBy.tickQueue.remove(this.tickScheduleHolder);
                }
                this.tickScheduleHolder = null;
            }
            if (this.taskScheduleHolder != null) {
                if (this.ownedBy != null) {
                    this.ownedBy.taskQueue.remove(this.taskScheduleHolder);
                }
                this.taskScheduleHolder = null;
            }
            this.state = 32;
            this.scheduledTo.tickCancelled(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishTickExecution(boolean cancel) {
            ScheduledState scheduledState = this;
            synchronized (scheduledState) {
                if (this.state != 8 && this.state != 16) {
                    throw new IllegalStateException("Must be running here");
                }
                if (cancel || this.state == 16) {
                    this.doCancel();
                    return;
                }
                if (this.taskScheduleHolder != null) {
                    if (this.ownedBy != null) {
                        this.ownedBy.taskQueue.remove(this.taskScheduleHolder);
                    }
                    this.taskScheduleHolder = null;
                }
                this.tickScheduleHolder = null;
                this.reschedule(false);
                this.state = 2;
            }
        }
    }

    private static final class TaskScheduleHolder {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final long id = ID_GENERATOR.getAndIncrement();
        private static final Comparator<TaskScheduleHolder> COMPARATOR = (h1, h2) -> {
            int timeCompare = TimeUtil.compareTimes(h2.lastDrainedTasks, h1.lastDrainedTasks);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return Long.compare(h1.id, h2.id);
        };
        private final ScheduledState task;
        private final long lastDrainedTasks;

        private TaskScheduleHolder(ScheduledState task, long lastDrainedTasks) {
            this.task = task;
            this.lastDrainedTasks = lastDrainedTasks;
        }
    }

    private static final class TickScheduleHolder {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final long id = ID_GENERATOR.getAndIncrement();
        private static final Comparator<TickScheduleHolder> COMPARATOR = (h1, h2) -> {
            int timeCompare = TimeUtil.compareTimes(h1.atNS, h2.atNS);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return Long.compare(h1.id, h2.id);
        };
        private final ScheduledState tick;
        private final long atNS;
        private final boolean stolen;

        private TickScheduleHolder(ScheduledState tick, long atNS, boolean stolen) {
            this.tick = tick;
            this.atNS = atNS;
            this.stolen = stolen;
        }
    }
}

