/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.util;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import java.util.Objects;

public final class FlatBitsetUtil {
    private static final int LOG2_LONG = 6;
    private static final long ALL_SET = -1L;
    private static final int BITS_PER_LONG = 64;

    public static int[] bitsetToInts(long[] bitset) {
        IntArrayList ret = new IntArrayList(bitset.length << 6);
        int offset = 0;
        for (long mask : bitset) {
            int len = Long.bitCount(mask);
            for (int i = 0; i < len; ++i) {
                ret.add(offset | Long.numberOfTrailingZeros(mask));
                mask ^= IntegerUtil.getTrailingBit(mask);
            }
            offset += 64;
        }
        return ret.toIntArray();
    }

    public static long[] intsToBitset(int[] ints) {
        BitSet bitSet = new BitSet();
        for (int idx : ints) {
            bitSet.set(idx);
        }
        return bitSet.toLongArray();
    }

    public static boolean get(long[] bitset, int index) {
        int arrIdx = index >> 6;
        return arrIdx >= 0 && arrIdx < bitset.length && (bitset[arrIdx] & 1L << index) != 0L;
    }

    public static int firstSet(long[] bitset, int from, int to) {
        if ((from | to | to - from) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bitsetIdx = from >>> 6;
        int bitIdx = from & 0xFFFFFFC0;
        long tmp = bitset[bitsetIdx] & -1L << from;
        while (true) {
            if (tmp != 0L) {
                int ret = bitIdx | Long.numberOfTrailingZeros(tmp);
                return ret >= to ? -1 : ret;
            }
            if ((bitIdx += 64) >= to) {
                return -1;
            }
            tmp = bitset[++bitsetIdx];
        }
    }

    public static int firstClear(long[] bitset, int from, int to) {
        if ((from | to | to - from) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bitsetIdx = from >>> 6;
        int bitIdx = from & 0xFFFFFFC0;
        long tmp = (bitset[bitsetIdx] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << from;
        while (true) {
            if (tmp != 0L) {
                int ret = bitIdx | Long.numberOfTrailingZeros(tmp);
                return ret >= to ? -1 : ret;
            }
            if ((bitIdx += 64) >= to) {
                return -1;
            }
            tmp = bitset[++bitsetIdx] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static void clearRange(long[] bitset, int from, int to) {
        if ((from | to | to - from) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int fromBitsetIdx = from >>> 6;
        int toBitsetIdx = --to >>> 6;
        long keepFirst = -1L << from ^ 0xFFFFFFFFFFFFFFFFL;
        long keepLast = -1L >>> (0x3F ^ to) ^ 0xFFFFFFFFFFFFFFFFL;
        Objects.checkFromToIndex(fromBitsetIdx, toBitsetIdx, bitset.length);
        if (fromBitsetIdx == toBitsetIdx) {
            int n = fromBitsetIdx;
            bitset[n] = bitset[n] & (keepFirst | keepLast);
        } else {
            int n = fromBitsetIdx;
            bitset[n] = bitset[n] & keepFirst;
            for (int i = fromBitsetIdx + 1; i < toBitsetIdx; ++i) {
                bitset[i] = 0L;
            }
            int n2 = toBitsetIdx;
            bitset[n2] = bitset[n2] & keepLast;
        }
    }

    public static boolean isRangeSet(long[] bitset, int from, int to) {
        return FlatBitsetUtil.firstClear(bitset, from, to) == -1;
    }

    private FlatBitsetUtil() {
    }
}

