/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.world;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.event.HandlerList;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.generator.structure.Structure;
import org.bukkit.util.BlockTransformer;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EntityTransformer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Experimental
public class AsyncStructureGenerateEvent
extends WorldEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Cause cause;
    private final Structure structure;
    private final BoundingBox boundingBox;
    private final int chunkX;
    private final int chunkZ;
    private final Map<NamespacedKey, BlockTransformer> blockTransformers = new LinkedHashMap<NamespacedKey, BlockTransformer>();
    private final Map<NamespacedKey, EntityTransformer> entityTransformers = new LinkedHashMap<NamespacedKey, EntityTransformer>();

    @ApiStatus.Internal
    public AsyncStructureGenerateEvent(@NotNull World world, boolean async, @NotNull Cause cause, @NotNull Structure structure, @NotNull BoundingBox boundingBox, int chunkX, int chunkZ) {
        super(world, async);
        this.cause = cause;
        this.structure = structure;
        this.boundingBox = boundingBox;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    @NotNull
    public Cause getCause() {
        return this.cause;
    }

    @NotNull
    public Structure getStructure() {
        return this.structure;
    }

    @NotNull
    public BoundingBox getBoundingBox() {
        return this.boundingBox.clone();
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    @Nullable
    public BlockTransformer getBlockTransformer(@NotNull NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        return this.blockTransformers.get(key);
    }

    public void setBlockTransformer(@NotNull NamespacedKey key, @NotNull BlockTransformer transformer) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        Preconditions.checkArgument((transformer != null ? 1 : 0) != 0, (Object)"BlockTransformer cannot be null");
        this.blockTransformers.put(key, transformer);
    }

    public void removeBlockTransformer(@NotNull NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        this.blockTransformers.remove(key);
    }

    public void clearBlockTransformers() {
        this.blockTransformers.clear();
    }

    @NotNull
    public @Unmodifiable Map<NamespacedKey, BlockTransformer> getBlockTransformers() {
        return Collections.unmodifiableMap(this.blockTransformers);
    }

    @Nullable
    public EntityTransformer getEntityTransformer(@NotNull NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        return this.entityTransformers.get(key);
    }

    public void setEntityTransformer(@NotNull NamespacedKey key, @NotNull EntityTransformer transformer) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        Preconditions.checkArgument((transformer != null ? 1 : 0) != 0, (Object)"EntityTransformer cannot be null");
        this.entityTransformers.put(key, transformer);
    }

    public void removeEntityTransformer(@NotNull NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        this.entityTransformers.remove(key);
    }

    public void clearEntityTransformers() {
        this.entityTransformers.clear();
    }

    @NotNull
    public @Unmodifiable Map<NamespacedKey, EntityTransformer> getEntityTransformers() {
        return Collections.unmodifiableMap(this.entityTransformers);
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Cause {
        COMMAND,
        WORLD_GENERATION,
        CUSTOM;

    }
}

